/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.data.client;

import mrbysco.constructionstick.items.stick.ItemStick;
import mrbysco.constructionstick.registry.ModItems;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(PackOutput packOutput, ExistingFileHelper existingFileHelper) {
        super(packOutput, "constructionstick", existingFileHelper);
    }

    protected void registerModels() {
        for (DeferredHolder deferredHolder : ModItems.ITEMS.getEntries()) {
            Item item = (Item)deferredHolder.get();
            String name = deferredHolder.getId().getPath();
            if (item instanceof ItemStick) {
                this.generateStick(name);
                continue;
            }
            if (item instanceof BlockItem) {
                this.withExistingParent(name, this.modLoc("block/" + name));
                continue;
            }
            ((ItemModelBuilder)this.withExistingParent(name, "item/generated")).texture("layer0", "item/" + name);
        }
    }

    private void generateStick(String name) {
        ModelBuilder stickAngel = ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name + "_angel", "item/handheld")).texture("layer0", this.modLoc("item/" + name))).texture("layer1", this.modLoc("item/overlay_angel"));
        ModelBuilder stickDestruction = ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name + "_destruction", "item/handheld")).texture("layer0", this.modLoc("item/" + name))).texture("layer1", this.modLoc("item/overlay_destruction"));
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, "item/handheld")).texture("layer0", this.modLoc("item/" + name))).override().predicate(this.modLoc("angel_selected"), 1.0f).model((ModelFile)stickAngel).end().override().predicate(this.modLoc("destruction_selected"), 1.0f).model((ModelFile)stickDestruction).end();
    }

    @NotNull
    public String getName() {
        return "ConstructionSticks item models";
    }
}

