/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.api.component;

import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.impl.component.config.IOSideConfig;
import java.util.Locale;
import net.minecraft.network.chat.Component;

public enum ComponentIOMode {
    INPUT(true, false, IOSideConfig.Template.DEFAULT_ALL_INPUT),
    OUTPUT(false, true, IOSideConfig.Template.DEFAULT_ALL_OUTPUT),
    BOTH(true, true, IOSideConfig.Template.DEFAULT_ALL_BOTH),
    NONE(false, false, IOSideConfig.Template.DEFAULT_ALL_NONE);

    public static final NamedCodec<ComponentIOMode> CODEC;
    private final boolean isInput;
    private final boolean isOutput;
    private final IOSideConfig.Template baseConfig;

    private ComponentIOMode(boolean isInput, boolean isOutput, IOSideConfig.Template baseConfig) {
        this.isInput = isInput;
        this.isOutput = isOutput;
        this.baseConfig = baseConfig;
    }

    public boolean isInput() {
        return this.isInput;
    }

    public boolean isOutput() {
        return this.isOutput;
    }

    public IOSideConfig.Template getBaseConfig() {
        return this.baseConfig;
    }

    public Component toComponent() {
        return Component.translatable((String)("custommachinery.machine.component.mode." + String.valueOf((Object)this)));
    }

    public static ComponentIOMode value(String value) {
        return ComponentIOMode.valueOf(value.toUpperCase(Locale.ENGLISH));
    }

    public String toString() {
        return super.toString().toLowerCase(Locale.ROOT);
    }

    static {
        CODEC = NamedCodec.enumCodec(ComponentIOMode.class);
    }
}

