/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.integration.jei.wrapper;

import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.integration.jei.IRecipeHelper;
import fr.frinn.custommachinery.client.integration.jei.CustomMachineryJEIPlugin;
import fr.frinn.custommachinery.common.component.item.ItemMachineComponent;
import fr.frinn.custommachinery.common.guielement.SlotGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;

public class FuelItemIngredientWrapper
implements IJEIIngredientWrapper<ItemStack> {
    private final int amount;

    public FuelItemIngredientWrapper(int amount) {
        this.amount = amount;
    }

    @Override
    public boolean setupRecipe(IRecipeLayoutBuilder builder, int xOffset, int yOffset, IGuiElement element, IRecipeHelper helper) {
        SlotGuiElement slotElement;
        block3: {
            block2: {
                if (!(element instanceof SlotGuiElement)) break block2;
                slotElement = (SlotGuiElement)element;
                if (element.getType() == Registration.SLOT_GUI_ELEMENT.get()) break block3;
            }
            return false;
        }
        return helper.getComponentForElement(slotElement).map(t -> {
            ItemMachineComponent.Template template;
            if (t instanceof ItemMachineComponent.Template && (template = (ItemMachineComponent.Template)t).getType() == Registration.ITEM_FUEL_MACHINE_COMPONENT.get()) {
                List<ItemStack> ingredients = CustomMachineryJEIPlugin.FUEL_INGREDIENTS.stream().filter(stack -> template.canAccept(stack, true, helper.getDummyManager())).toList();
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, element.getX() - xOffset + 1, element.getY() - yOffset + 1).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, ingredients)).addRichTooltipCallback((view, tooltips) -> view.getDisplayedIngredient((IIngredientType)VanillaTypes.ITEM_STACK).ifPresent(stack -> {
                    tooltips.add((FormattedText)Component.translatable((String)"custommachinery.jei.ingredient.fuel.amount", (Object[])new Object[]{this.amount}).withStyle(ChatFormatting.GOLD));
                    tooltips.add((FormattedText)Component.translatable((String)"custommachinery.jei.ingredient.fuel.burntime", (Object[])new Object[]{stack.getBurnTime(RecipeType.SMELTING)}).withStyle(ChatFormatting.GRAY));
                }));
                return true;
            }
            return false;
        }).orElse(false);
    }
}

