/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.integration.jei.wrapper;

import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.integration.jei.IRecipeHelper;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.common.guielement.SlotGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.ingredients.IIngredientType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public class ItemIngredientWrapper
implements IJEIIngredientWrapper<ItemStack> {
    private final RequirementIOMode mode;
    private final SizedIngredient ingredient;
    private final double chance;
    private final boolean useDurability;
    private final String slot;
    private final boolean showRequireSlot;

    public ItemIngredientWrapper(RequirementIOMode mode, SizedIngredient ingredient, double chance, boolean useDurability, String slot, boolean showRequireSlot) {
        this.mode = mode;
        this.ingredient = ingredient;
        this.chance = chance;
        this.useDurability = useDurability;
        this.slot = slot;
        this.showRequireSlot = showRequireSlot;
    }

    @Override
    public boolean setupRecipe(IRecipeLayoutBuilder builder, int xOffset, int yOffset, IGuiElement element, IRecipeHelper helper) {
        SlotGuiElement slotElement;
        block5: {
            block4: {
                if (!(element instanceof SlotGuiElement)) break block4;
                slotElement = (SlotGuiElement)element;
                if (element.getType() == Registration.SLOT_GUI_ELEMENT.get()) break block5;
            }
            return false;
        }
        List ingredients = Arrays.stream(this.ingredient.ingredient().getItems()).map(item -> item.copyWithCount(this.ingredient.count())).collect(Collectors.toCollection(ArrayList::new));
        Optional<IMachineComponentTemplate<?>> template = helper.getComponentForElement(slotElement);
        if (slotElement.getComponentId().equals(this.slot) || template.map(t -> t.getType() != Registration.ITEM_FILTER_MACHINE_COMPONENT.get() && t.canAccept(ingredients, this.mode == RequirementIOMode.INPUT, helper.getDummyManager()) && (this.slot.isEmpty() || t.getId().equals(this.slot))).orElse(false).booleanValue()) {
            int slotX = element.getX() + (element.getWidth() - 16) / 2;
            int slotY = element.getY() + (element.getHeight() - 16) / 2;
            ((IRecipeSlotBuilder)builder.addSlot(this.roleFromMode(this.mode), slotX - xOffset, slotY - yOffset).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, ingredients)).setSlotName(slotElement.getComponentId()).addRichTooltipCallback((view, tooltips) -> {
                if (this.useDurability && this.mode == RequirementIOMode.INPUT) {
                    tooltips.add((FormattedText)Component.translatable((String)"custommachinery.jei.ingredient.item.durability.consume", (Object[])new Object[]{this.ingredient.count()}));
                } else if (this.useDurability && this.mode == RequirementIOMode.OUTPUT) {
                    tooltips.add((FormattedText)Component.translatable((String)"custommachinery.jei.ingredient.item.durability.repair", (Object[])new Object[]{this.ingredient.count()}));
                }
                if (this.chance == 0.0) {
                    tooltips.add((FormattedText)Component.translatable((String)"custommachinery.jei.ingredient.chance.0").withStyle(ChatFormatting.DARK_RED));
                } else if (this.chance != 1.0) {
                    double percentage = this.chance * 100.0;
                    if (percentage < (double)0.01f) {
                        tooltips.add((FormattedText)Component.translatable((String)"custommachinery.jei.ingredient.chance", (Object[])new Object[]{"<0.01"}));
                    } else {
                        BigDecimal decimal = BigDecimal.valueOf(percentage).setScale(2, RoundingMode.HALF_UP);
                        if (decimal.scale() <= 0 || decimal.signum() == 0 || decimal.stripTrailingZeros().scale() <= 0) {
                            tooltips.add((FormattedText)Component.translatable((String)"custommachinery.jei.ingredient.chance", (Object[])new Object[]{decimal.intValue()}));
                        } else {
                            tooltips.add((FormattedText)Component.translatable((String)"custommachinery.jei.ingredient.chance", (Object[])new Object[]{decimal.doubleValue()}));
                        }
                    }
                }
                if (!this.slot.isEmpty() && this.showRequireSlot && Minecraft.getInstance().options.advancedItemTooltips) {
                    tooltips.add((FormattedText)Component.translatable((String)"custommachinery.jei.ingredient.item.specificSlot").withStyle(ChatFormatting.DARK_RED));
                }
            });
            return true;
        }
        return false;
    }
}

