/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.gui.builder;

import fr.frinn.custommachinery.api.guielement.GuiElementType;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.gui.GuiElementBuilderPopup;
import fr.frinn.custommachinery.client.screen.creation.gui.IGuiElementBuilder;
import fr.frinn.custommachinery.client.screen.creation.gui.MutableProperties;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.common.guielement.SplitButtonGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.guielement.AbstractGuiElement;
import fr.frinn.custommachinery.impl.util.TextureInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class SplitButtonGuiElementBuilder
implements IGuiElementBuilder<SplitButtonGuiElement> {
    @Override
    public GuiElementType<SplitButtonGuiElement> type() {
        return Registration.SPLIT_GUI_ELEMENT.get();
    }

    @Override
    public SplitButtonGuiElement make(AbstractGuiElement.Properties properties, @Nullable SplitButtonGuiElement from) {
        if (from != null) {
            return new SplitButtonGuiElement(properties, from.getTextureToggle(), from.getTextureToggleHovered(), from.getSlots());
        }
        return new SplitButtonGuiElement(properties, SplitButtonGuiElement.BASE_TEXTURE_TOGGLE, SplitButtonGuiElement.BASE_TEXTURE_TOGGLE_HOVERED, Collections.emptyList());
    }

    @Override
    public PopupScreen makeConfigPopup(MachineEditScreen parent, MutableProperties properties, @Nullable SplitButtonGuiElement from, Consumer<SplitButtonGuiElement> onFinish) {
        return new SplitButtonGuiElementBuilderPopup((BaseScreen)parent, properties, from, onFinish);
    }

    public static class SplitButtonGuiElementBuilderPopup
    extends GuiElementBuilderPopup<SplitButtonGuiElement> {
        private TextureInfo textureToggle = SplitButtonGuiElement.BASE_TEXTURE_TOGGLE;
        private TextureInfo textureToggleHovered = SplitButtonGuiElement.BASE_TEXTURE_TOGGLE_HOVERED;
        private EditBox slots;

        public SplitButtonGuiElementBuilderPopup(BaseScreen parent, MutableProperties properties, @Nullable SplitButtonGuiElement from, Consumer<SplitButtonGuiElement> onFinish) {
            super(parent, properties, from, onFinish);
            if (from != null) {
                this.textureToggle = from.getTextureToggle();
                this.textureToggleHovered = from.getTextureToggleHovered();
            }
        }

        @Override
        public SplitButtonGuiElement makeElement() {
            List<String> slots = Arrays.stream(this.slots.getValue().split(",")).filter(s -> !s.isEmpty()).toList();
            return new SplitButtonGuiElement(this.properties.build(), this.textureToggle, this.textureToggleHovered, slots);
        }

        @Override
        public Component canCreate() {
            if (this.properties.getId().isEmpty()) {
                return Component.translatable((String)"custommachinery.gui.creation.gui.id.missing");
            }
            return super.canCreate();
        }

        @Override
        public void addWidgets(GridLayout.RowHelper row) {
            this.addTexture(row, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.texture"), this.properties::setTexture, this.baseElement != null ? ((SplitButtonGuiElement)this.baseElement).getTexture() : SplitButtonGuiElement.BASE_TEXTURE);
            this.addTexture(row, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.texture_hovered"), this.properties::setTextureHovered, this.baseElement != null ? ((SplitButtonGuiElement)this.baseElement).getTextureHovered() : SplitButtonGuiElement.BASE_TEXTURE_HOVERED);
            this.addTexture(row, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.button.texture_toggle"), texture -> {
                this.textureToggle = texture;
            }, this.textureToggle);
            this.addTexture(row, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.button.texture_toggle_hovered"), texture -> {
                this.textureToggleHovered = texture;
            }, this.textureToggleHovered);
            this.addId(row);
            this.addPriority(row);
            row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.split.slots"), this.font));
            this.slots = (EditBox)row.addChild((LayoutElement)new EditBox(this.font, 100, 20, (Component)Component.empty()));
            this.slots.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.gui.split.slots.tooltip")));
            if (this.baseElement != null) {
                this.slots.setValue(this.listToString(((SplitButtonGuiElement)this.baseElement).getSlots()));
            }
        }

        private <T> String listToString(List<T> list) {
            StringBuilder builder = new StringBuilder();
            Iterator<T> iterator = list.iterator();
            while (iterator.hasNext()) {
                T next = iterator.next();
                builder.append(next.toString());
                if (!iterator.hasNext()) continue;
                builder.append(",");
            }
            return builder.toString();
        }
    }
}

