/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.upgrade;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.upgrade.UpgradeListSorting;
import fr.frinn.custommachinery.client.screen.widget.ListWidget;
import fr.frinn.custommachinery.common.config.CMConfig;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.upgrade.MachineUpgrade;
import fr.frinn.custommachinery.common.upgrade.UpgradeLocation;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class UpgradeListWidget
extends ListWidget<UpgradeEntry> {
    public UpgradeListWidget(int x, int y, int width, int height, int itemHeight) {
        super(x, y, width, height, itemHeight, (Component)Component.empty());
        this.setRenderSelection();
    }

    public void reload() {
        this.clear();
        CustomMachinery.UPGRADES.getAllUpgrades().forEach((location, upgrade) -> this.addEntry(new UpgradeEntry((UpgradeLocation)location, (MachineUpgrade)upgrade)));
    }

    public void sort() {
        this.sort(switch ((UpgradeListSorting)((Object)CMConfig.CONFIG.sortUpgradeList.get())) {
            default -> throw new MatchException(null, null);
            case UpgradeListSorting.ITEM -> Comparator.comparing(entry -> BuiltInRegistries.ITEM.getKey((Object)entry.getUpgrade().item()));
            case UpgradeListSorting.MACHINE -> Comparator.comparing(entry -> entry.getUpgrade().machines().isEmpty() ? "zzz" : entry.getUpgrade().machines().getFirst().toString());
            case UpgradeListSorting.NEWEST -> Comparator.comparing(entry -> entry.getLocation().modified()).reversed();
            case UpgradeListSorting.OLDEST -> Comparator.comparing(entry -> entry.getLocation().modified());
        });
    }

    public static class UpgradeEntry
    extends ListWidget.Entry {
        private final Minecraft mc = Minecraft.getInstance();
        private final UpgradeLocation location;
        private final MachineUpgrade upgrade;

        public UpgradeEntry(UpgradeLocation location, MachineUpgrade upgrade) {
            this.location = location;
            this.upgrade = upgrade;
        }

        public UpgradeLocation getLocation() {
            return this.location;
        }

        public MachineUpgrade getUpgrade() {
            return this.upgrade;
        }

        @Override
        protected void render(GuiGraphics graphics, int index, int x, int y, int width, int height, int mouseX, int mouseY, float partialTicks) {
            graphics.renderItem(this.upgrade.item().getDefaultInstance(), x + 2, y + height / 2 - 8);
            MutableComponent machines = Component.empty();
            Iterator<ResourceLocation> iterator = this.upgrade.machines().iterator();
            while (iterator.hasNext()) {
                machines.append(CustomMachinery.MACHINES.getOrDefault(iterator.next(), CustomMachine.DUMMY).getName());
                if (!iterator.hasNext()) continue;
                machines.append(", ");
            }
            Font font = this.mc.font;
            int n = y + height / 2;
            Objects.requireNonNull(this.mc.font);
            ClientHandler.renderScrollingStringNoShadow(graphics, font, (Component)machines, x + 20, x + width - 20, n - 9 / 2 - 6, 0);
            Font font2 = this.mc.font;
            MutableComponent mutableComponent = Component.literal((String)this.location.id().toString()).withStyle(ChatFormatting.DARK_GRAY);
            int n2 = y + height / 2;
            Objects.requireNonNull(this.mc.font);
            BaseScreen.drawScaledString(graphics, font2, (Component)mutableComponent, x + 20, n2 - 9 / 2 + 2, 0.8f, 0, false);
            Font font3 = this.mc.font;
            MutableComponent mutableComponent2 = this.location.loader().getTranslatedName().withStyle(ChatFormatting.ITALIC);
            int n3 = y + height / 2;
            Objects.requireNonNull(this.mc.font);
            BaseScreen.drawScaledString(graphics, font3, (Component)mutableComponent2, x + 20, n3 - 9 / 2 + 9, 0.7f, 0, false);
            if (this.location.created().toMillis() != 0L) {
                String creationTime = new SimpleDateFormat("dd/MM/yy HH:mm").format(this.location.created().toMillis());
                MutableComponent creation = Component.translatable((String)"custommachinery.gui.creation.time.created", (Object[])new Object[]{creationTime}).withStyle(ChatFormatting.DARK_GRAY);
                Font font4 = this.mc.font;
                int n4 = x + width - this.mc.font.width((FormattedText)creation) / 2 - 10;
                int n5 = y + height / 2;
                Objects.requireNonNull(this.mc.font);
                BaseScreen.drawScaledString(graphics, font4, (Component)creation, n4, n5 - 9 / 2 + 2, 0.5f, 0, false);
            }
            if (this.location.modified().toMillis() != 0L) {
                String modificationTime = new SimpleDateFormat("dd/MM/yy HH:mm").format(this.location.modified().toMillis());
                MutableComponent modification = Component.translatable((String)"custommachinery.gui.creation.time.modified", (Object[])new Object[]{modificationTime}).withStyle(ChatFormatting.DARK_GRAY);
                Font font5 = this.mc.font;
                int n6 = x + width - this.mc.font.width((FormattedText)modification) / 2 - 11;
                int n7 = y + height / 2;
                Objects.requireNonNull(this.mc.font);
                BaseScreen.drawScaledString(graphics, font5, (Component)modification, n6, n7 - 9 / 2 + 9, 0.5f, 0, false);
            }
        }

        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }
    }
}

