/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class CommandMachineComponent
extends AbstractMachineComponent {
    private static final CommandSource COMMAND_SOURCE_LOG = new CommandSource(){

        public void sendSystemMessage(Component component) {
            CustomMachinery.LOGGER.info(component.getString());
        }

        public boolean acceptsSuccess() {
            return false;
        }

        public boolean acceptsFailure() {
            return true;
        }

        public boolean shouldInformAdmins() {
            return true;
        }
    };
    private static final CommandSource COMMAND_SOURCE_NO_LOG = new CommandSource(){

        public void sendSystemMessage(Component component) {
            CustomMachinery.LOGGER.info(component.getString());
        }

        public boolean acceptsSuccess() {
            return false;
        }

        public boolean acceptsFailure() {
            return true;
        }

        public boolean shouldInformAdmins() {
            return false;
        }
    };

    public CommandMachineComponent(IMachineComponentManager manager) {
        super(manager, ComponentIOMode.NONE);
    }

    public void sendCommand(String command, int permissionLevel, boolean log) {
        if (this.getManager().getLevel().getServer() == null) {
            return;
        }
        CommandSourceStack source = new CommandSourceStack(log ? COMMAND_SOURCE_LOG : COMMAND_SOURCE_NO_LOG, Vec3.atCenterOf((Vec3i)this.getManager().getTile().getBlockPos()), this.getMachineRotation(), (ServerLevel)this.getManager().getLevel(), permissionLevel, "Custom Machinery", this.getManager().getTile().getMachine().getName(), this.getManager().getServer(), null);
        this.getManager().getLevel().getServer().getCommands().performPrefixedCommand(source, command);
    }

    public MachineComponentType<CommandMachineComponent> getType() {
        return Registration.COMMAND_MACHINE_COMPONENT.get();
    }

    private Vec2 getMachineRotation() {
        Direction facing = (Direction)this.getManager().getTile().getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return new Vec2(0.0f, facing.toYRot() - 180.0f);
    }
}

