/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component;

import com.google.common.base.Suppliers;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.CustomMachineDamageSource;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;

public class EntityMachineComponent
extends AbstractMachineComponent {
    private final Supplier<CustomMachineDamageSource> damageSource = Suppliers.memoize(() -> new CustomMachineDamageSource(manager.getTile()));

    public EntityMachineComponent(IMachineComponentManager manager) {
        super(manager, ComponentIOMode.BOTH);
    }

    public MachineComponentType<EntityMachineComponent> getType() {
        return Registration.ENTITY_MACHINE_COMPONENT.get();
    }

    public int getEntitiesInRadius(int radius, Predicate<Entity> filter) {
        BlockPos pos = this.getManager().getTile().getBlockPos();
        AABB bb = new AABB((double)(pos.getX() - radius), (double)(pos.getY() - radius), (double)(pos.getZ() - radius), (double)(pos.getX() + radius), (double)(pos.getY() + radius), (double)(pos.getZ() + radius));
        return this.getManager().getLevel().getEntitiesOfClass(Entity.class, bb, entity -> entity.distanceToSqr(Utils.vec3dFromBlockPos(pos)) <= (double)(radius * radius) && filter.test((Entity)entity)).size();
    }

    public double getEntitiesInRadiusHealth(int radius, Predicate<Entity> filter) {
        BlockPos pos = this.getManager().getTile().getBlockPos();
        AABB bb = new AABB((double)(pos.getX() - radius), (double)(pos.getY() - radius), (double)(pos.getZ() - radius), (double)(pos.getX() + radius), (double)(pos.getY() + radius), (double)(pos.getZ() + radius));
        return this.getManager().getLevel().getEntitiesOfClass(LivingEntity.class, bb, entity -> filter.test((Entity)entity) && entity.distanceToSqr(Utils.vec3dFromBlockPos(pos)) <= (double)(radius * radius)).stream().mapToDouble(LivingEntity::getHealth).sum();
    }

    public void removeEntitiesHealth(int radius, Predicate<Entity> filter, int amount) {
        BlockPos pos = this.getManager().getTile().getBlockPos();
        AtomicInteger toRemove = new AtomicInteger(amount);
        AABB bb = new AABB((double)(pos.getX() - radius), (double)(pos.getY() - radius), (double)(pos.getZ() - radius), (double)(pos.getX() + radius), (double)(pos.getY() + radius), (double)(pos.getZ() + radius));
        this.getManager().getLevel().getEntitiesOfClass(LivingEntity.class, bb, entity -> filter.test((Entity)entity) && entity.distanceToSqr(Utils.vec3dFromBlockPos(pos)) <= (double)(radius * radius)).forEach(entity -> {
            int maxRemove = Math.min((int)entity.getHealth(), toRemove.get());
            entity.hurt((DamageSource)this.damageSource.get(), (float)maxRemove);
            toRemove.addAndGet(-maxRemove);
        });
    }

    public void killEntities(int radius, Predicate<Entity> filter, int amount) {
        BlockPos pos = this.getManager().getTile().getBlockPos();
        AABB bb = new AABB((double)(pos.getX() - radius), (double)(pos.getY() - radius), (double)(pos.getZ() - radius), (double)(pos.getX() + radius), (double)(pos.getY() + radius), (double)(pos.getZ() + radius));
        this.getManager().getLevel().getEntitiesOfClass(LivingEntity.class, bb, entity -> filter.test((Entity)entity) && entity.distanceToSqr(Utils.vec3dFromBlockPos(pos)) <= (double)(radius * radius)).stream().limit(amount).forEach(entity -> entity.hurt((DamageSource)this.damageSource.get(), Float.MAX_VALUE));
    }
}

