/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.crafting.craft;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fr.frinn.custommachinery.api.ICustomMachineryAPI;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.RecipeRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.common.init.Registration;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CustomCraftRecipe
implements Recipe<RecipeInput>,
IMachineRecipe {
    public static final List<RequirementType<?>> FORBIDDEN_REQUIREMENTS = Lists.newArrayList((Object[])new RequirementType[]{Registration.ENERGY_PER_TICK_REQUIREMENT.get(), Registration.FLUID_PER_TICK_REQUIREMENT.get(), Registration.EXPERIENCE_PER_TICK_REQUIREMENT.get()});
    private final ResourceLocation machine;
    private final ItemStack output;
    private final List<RecipeRequirement<?, ?>> requirements;
    private final List<RecipeRequirement<?, ?>> jeiRequirements;
    private final int priority;
    private final int jeiPriority;
    private final boolean hidden;

    public CustomCraftRecipe(ResourceLocation machine, ItemStack output, List<RecipeRequirement<?, ?>> requirements, List<RecipeRequirement<?, ?>> jeiRequirements, int priority, int jeiPriority, boolean hidden) {
        this.machine = machine;
        this.output = output;
        this.requirements = this.validateRequirements(requirements);
        this.jeiRequirements = this.validateRequirements(jeiRequirements);
        this.priority = priority;
        this.jeiPriority = jeiPriority;
        this.hidden = hidden;
    }

    @Override
    public ResourceLocation getMachineId() {
        return this.machine;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    private List<RecipeRequirement<?, ?>> validateRequirements(List<RecipeRequirement<?, ?>> requirements) {
        return requirements.stream().filter(requirement -> {
            if (!FORBIDDEN_REQUIREMENTS.contains(requirement.requirement().getType())) {
                return true;
            }
            ICustomMachineryAPI.INSTANCE.logger().error("Invalid requirement: {} in craft recipe", (Object)IRequirement.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, requirement.requirement()).result().map(JsonElement::toString).orElse(requirement.requirement().getType().toString()));
            return false;
        }).toList();
    }

    @Override
    public int getRecipeTime() {
        return 0;
    }

    @Override
    public List<RecipeRequirement<?, ?>> getRequirements() {
        return this.requirements;
    }

    @Override
    public List<RecipeRequirement<?, ?>> getJeiRequirements() {
        return this.jeiRequirements;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int getJeiPriority() {
        return this.jeiPriority;
    }

    @Override
    public boolean shouldResetOnError() {
        return false;
    }

    @Override
    public boolean showInJei() {
        return !this.hidden;
    }

    public boolean matches(RecipeInput p_346065_, Level p_345375_) {
        return false;
    }

    public ItemStack assemble(RecipeInput p_345149_, HolderLookup.Provider p_346030_) {
        return null;
    }

    public boolean canCraftInDimensions(int i, int j) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return null;
    }

    public RecipeSerializer<?> getSerializer() {
        return Registration.CUSTOM_CRAFT_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)Registration.CUSTOM_CRAFT_RECIPE.get();
    }
}

