/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.crafting.machine;

import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.api.machine.MachineTile;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.api.requirement.RecipeRequirement;
import fr.frinn.custommachinery.common.crafting.CraftingContext;
import fr.frinn.custommachinery.common.crafting.machine.CustomMachineRecipe;
import fr.frinn.custommachinery.common.crafting.machine.MachineProcessor;
import fr.frinn.custommachinery.common.crafting.machine.MachineRecipeFinder;
import fr.frinn.custommachinery.common.network.syncable.DoubleSyncable;
import fr.frinn.custommachinery.common.network.syncable.IntegerSyncable;
import fr.frinn.custommachinery.common.network.syncable.StringSyncable;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.impl.crafting.RequirementList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MachineProcessorCore
implements ISyncableStuff {
    private final MachineProcessor processor;
    private final MachineTile tile;
    private final Random rand = Utils.RAND;
    private final MachineRecipeFinder recipeFinder;
    @Nullable
    private RecipeHolder<CustomMachineRecipe> currentRecipe;
    private ResourceLocation futureRecipeID;
    private CraftingContext context;
    private double recipeProgressTime = 0.0;
    private int recipeTotalTime = 0;
    private boolean searchImmediately = false;
    private Phase phase = Phase.CONDITIONS;
    @Nullable
    private Component error = null;
    private boolean isLastRecipeTick = false;
    private MachineStatus status = MachineStatus.IDLE;
    private RequirementList<?> requirementList;
    private final List<RequirementList.RequirementWithFunction> currentProcessRequirements = new ArrayList<RequirementList.RequirementWithFunction>();

    public MachineProcessorCore(MachineProcessor processor, MachineTile tile, int baseCooldown, int core) {
        this.processor = processor;
        this.tile = tile;
        this.recipeFinder = new MachineRecipeFinder(tile, processor, baseCooldown, new CraftingContext.Mutable(tile, tile.getUpgradeManager(), core - 1), core);
    }

    @Nullable
    public RecipeHolder<CustomMachineRecipe> getCurrentRecipe() {
        return this.currentRecipe;
    }

    @Nullable
    public Component getError() {
        return this.error;
    }

    public double getRecipeProgressTime() {
        return this.recipeProgressTime;
    }

    public double getRecipeTotalTime() {
        return this.recipeTotalTime;
    }

    public MachineStatus getStatus() {
        return this.status;
    }

    public void init() {
        if (this.futureRecipeID != null && this.tile.getLevel() != null) {
            this.tile.getLevel().getRecipeManager().byKey(this.futureRecipeID).filter(holder -> holder.value() instanceof CustomMachineRecipe).map(holder -> holder).ifPresent(recipe -> {
                this.setRecipe((RecipeHolder<CustomMachineRecipe>)recipe);
                this.requirementList.getProcessRequirements().entrySet().removeIf(entry -> (Double)entry.getKey() < this.recipeProgressTime / (double)this.recipeTotalTime);
            });
            this.futureRecipeID = null;
        }
        this.recipeFinder.init();
    }

    public void tick() {
        if (this.currentRecipe == null) {
            this.recipeFinder.findRecipe(this.searchImmediately).ifPresent(this::setRecipe);
            this.searchImmediately = false;
        }
        if (this.currentRecipe != null) {
            if (this.phase == Phase.CONDITIONS) {
                this.checkConditions();
            }
            if (this.phase == Phase.PROCESS) {
                this.processRequirements();
            }
            if (this.phase == Phase.PROCESS_TICK) {
                this.processTickRequirements();
            }
            if (this.currentRecipe != null && this.error == null && this.recipeProgressTime >= (double)this.recipeTotalTime - this.context.getModifiedSpeed()) {
                if (this.isLastRecipeTick) {
                    this.isLastRecipeTick = false;
                    this.reset();
                    this.recipeFinder.findRecipe(true).ifPresent(this::setRecipe);
                } else {
                    this.isLastRecipeTick = true;
                }
            }
        }
    }

    private void checkConditions() {
        CraftingResult result;
        for (RequirementList.RequirementWithFunction requirement : this.requirementList.getInventoryConditions()) {
            result = requirement.process(this.tile.getComponentManager(), this.context);
            if (result.isSuccess()) continue;
            if (this.currentRecipe != null && ((CustomMachineRecipe)this.currentRecipe.value()).shouldResetOnError()) {
                this.reset();
            } else {
                this.setError(result.getMessage());
            }
            return;
        }
        for (RequirementList.RequirementWithFunction requirement : this.requirementList.getWorldConditions()) {
            result = requirement.process(this.tile.getComponentManager(), this.context);
            if (result.isSuccess()) continue;
            if (this.currentRecipe != null && ((CustomMachineRecipe)this.currentRecipe.value()).shouldResetOnError()) {
                this.reset();
            } else {
                this.setError(result.getMessage());
            }
            return;
        }
        this.setRunning();
        this.phase = Phase.PROCESS;
    }

    private void processRequirements() {
        if (this.currentProcessRequirements.isEmpty()) {
            this.requirementList.getProcessRequirements().entrySet().removeIf(entry -> {
                if ((Double)entry.getKey() <= this.recipeProgressTime / (double)this.recipeTotalTime || this.isLastRecipeTick) {
                    this.currentProcessRequirements.addAll((Collection)entry.getValue());
                    return true;
                }
                return false;
            });
        }
        Iterator<RequirementList.RequirementWithFunction> iterator = this.currentProcessRequirements.iterator();
        while (iterator.hasNext()) {
            CraftingResult result;
            RequirementList.RequirementWithFunction requirement = iterator.next();
            if (!requirement.requirement().shouldSkip(this.tile.getComponentManager(), this.rand, this.context) && !(result = requirement.process(this.tile.getComponentManager(), this.context)).isSuccess()) {
                if (this.currentRecipe != null && ((CustomMachineRecipe)this.currentRecipe.value()).shouldResetOnError()) {
                    this.reset();
                } else {
                    this.setError(result.getMessage());
                }
                return;
            }
            iterator.remove();
        }
        this.setRunning();
        this.phase = Phase.PROCESS_TICK;
    }

    private void processTickRequirements() {
        if (this.currentProcessRequirements.isEmpty()) {
            this.currentProcessRequirements.addAll(this.requirementList.getTickableRequirements());
        }
        Iterator<RequirementList.RequirementWithFunction> iterator = this.currentProcessRequirements.iterator();
        while (iterator.hasNext()) {
            CraftingResult result;
            RequirementList.RequirementWithFunction requirement = iterator.next();
            if (!requirement.requirement().shouldSkip(this.tile.getComponentManager(), this.rand, this.context) && !(result = requirement.process(this.tile.getComponentManager(), this.context)).isSuccess()) {
                if (this.currentRecipe != null && ((CustomMachineRecipe)this.currentRecipe.value()).shouldResetOnError()) {
                    this.reset();
                } else {
                    this.setError(result.getMessage());
                }
                return;
            }
            iterator.remove();
        }
        this.setRunning();
        this.phase = Phase.CONDITIONS;
        this.recipeProgressTime += this.context.getModifiedSpeed();
    }

    private void setRecipe(@NotNull RecipeHolder<CustomMachineRecipe> recipe) {
        this.currentRecipe = recipe;
        this.context = new CraftingContext(this.tile, this.tile.getUpgradeManager(), recipe, () -> this.recipeProgressTime, this.processor.getCores().indexOf(this));
        this.recipeTotalTime = ((CustomMachineRecipe)this.currentRecipe.value()).getRecipeTime();
        this.requirementList = new RequirementList();
        ((CustomMachineRecipe)this.currentRecipe.value()).getRequirements().forEach(requirement -> {
            this.requirementList.setCurrentRequirement((RecipeRequirement<?, ?>)requirement);
            requirement.requirement().gatherRequirements(this.requirementList);
        });
        this.phase = Phase.CONDITIONS;
        this.setRunning();
    }

    private void setRunning() {
        this.error = null;
        this.processor.setRunning();
        this.status = MachineStatus.RUNNING;
    }

    private void setError(Component error) {
        this.error = error;
        this.processor.setError(error);
        this.status = MachineStatus.ERRORED;
    }

    public void reset() {
        this.currentRecipe = null;
        this.futureRecipeID = null;
        this.recipeProgressTime = 0.0;
        this.recipeTotalTime = 0;
        this.requirementList = null;
        this.context = null;
        this.phase = Phase.CONDITIONS;
        this.currentProcessRequirements.clear();
        this.status = MachineStatus.IDLE;
    }

    public void setSearchImmediately() {
        if (this.currentRecipe == null) {
            this.searchImmediately = true;
        }
    }

    public void setMachineInventoryChanged() {
        this.recipeFinder.setInventoryChanged(true);
    }

    public CompoundTag serialize() {
        CompoundTag nbt = new CompoundTag();
        if (this.currentRecipe != null) {
            nbt.putString("recipe", this.currentRecipe.id().toString());
        }
        nbt.putString("phase", this.phase.toString());
        nbt.putDouble("recipeProgressTime", this.recipeProgressTime);
        return nbt;
    }

    public void deserialize(CompoundTag nbt) {
        if (nbt.contains("recipe", 8)) {
            this.futureRecipeID = ResourceLocation.parse((String)nbt.getString("recipe"));
        }
        if (nbt.contains("phase", 8)) {
            this.phase = Phase.valueOf(nbt.getString("phase"));
        }
        if (nbt.contains("recipeProgressTime", 6)) {
            this.recipeProgressTime = nbt.getDouble("recipeProgressTime");
        }
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept(DoubleSyncable.create(() -> this.recipeProgressTime, recipeProgressTime -> {
            this.recipeProgressTime = recipeProgressTime;
        }));
        container.accept(IntegerSyncable.create(() -> this.recipeTotalTime, recipeTotalTime -> {
            this.recipeTotalTime = recipeTotalTime;
        }));
        container.accept(IntegerSyncable.create(() -> this.status.ordinal(), index -> {
            this.status = MachineStatus.values()[index];
        }));
        RegistryAccess registries = this.processor.tile().getLevel().registryAccess();
        container.accept(StringSyncable.create(() -> Component.Serializer.toJson((Component)(this.getError() == null ? Component.empty() : this.getError()), (HolderLookup.Provider)registries), errorMessage -> {
            this.error = Component.Serializer.fromJson((String)errorMessage, (HolderLookup.Provider)registries);
        }));
    }

    public static enum Phase {
        CONDITIONS,
        PROCESS,
        PROCESS_TICK;

    }
}

