/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.jade;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.crafting.IProcessor;
import fr.frinn.custommachinery.common.crafting.machine.CustomMachineRecipe;
import fr.frinn.custommachinery.common.crafting.machine.MachineProcessor;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IServerDataProvider;

public class CustomMachineServerDataProvider
implements IServerDataProvider<BlockAccessor> {
    public static final CustomMachineServerDataProvider INSTANCE = new CustomMachineServerDataProvider();
    public static final ResourceLocation ID = CustomMachinery.rl("machine_server_data_provider");

    public void appendServerData(CompoundTag nbt, BlockAccessor accessor) {
        CustomMachineTile machine;
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof CustomMachineTile && (machine = (CustomMachineTile)blockEntity).getLevel() != null) {
            IProcessor processor = machine.getProcessor();
            CompoundTag tag = new CompoundTag();
            if (machine.getOwnerName() != null) {
                tag.putString("owner", Component.Serializer.toJson((Component)machine.getOwnerName(), (HolderLookup.Provider)machine.getLevel().registryAccess()));
            }
            tag.putByte("status", (byte)machine.getStatus().ordinal());
            if (processor instanceof MachineProcessor) {
                MachineProcessor machineProcessor = (MachineProcessor)processor;
                ListTag cores = new ListTag();
                machineProcessor.getCores().forEach(core -> {
                    CompoundTag coreNbt = new CompoundTag();
                    if (core.getCurrentRecipe() != null) {
                        coreNbt.putDouble("recipeProgressTime", core.getRecipeProgressTime());
                        coreNbt.putInt("recipeTotalTime", ((CustomMachineRecipe)core.getCurrentRecipe().value()).getRecipeTime());
                    }
                    if (core.getError() != null) {
                        coreNbt.putString("errorMessage", Component.Serializer.toJson((Component)core.getError(), (HolderLookup.Provider)machine.getLevel().registryAccess()));
                    }
                });
                nbt.put("cores", (Tag)cores);
            }
            nbt.put("custommachinery", (Tag)tag);
        }
    }

    public ResourceLocation getUid() {
        return ID;
    }
}

