/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.init.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CSetFilterSlotItemPacket(ItemStack stack, BlockPos pos, String slotId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CSetFilterSlotItemPacket> TYPE = new CustomPacketPayload.Type(CustomMachinery.rl("set_filter_slot_item"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CSetFilterSlotItemPacket> CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, CSetFilterSlotItemPacket::stack, (StreamCodec)BlockPos.STREAM_CODEC, CSetFilterSlotItemPacket::pos, (StreamCodec)ByteBufCodecs.STRING_UTF8, CSetFilterSlotItemPacket::slotId, CSetFilterSlotItemPacket::new);

    public CustomPacketPayload.Type<CSetFilterSlotItemPacket> type() {
        return TYPE;
    }

    public static void handle(CSetFilterSlotItemPacket packet, IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            context.enqueueWork(() -> {
                BlockEntity patt0$temp = player2.level().getBlockEntity(packet.pos);
                if (patt0$temp instanceof CustomMachineTile) {
                    CustomMachineTile machine = (CustomMachineTile)patt0$temp;
                    machine.getComponentManager().getComponentHandler(Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(packet.slotId)).ifPresent(component -> {
                        if (component.getType() == Registration.ITEM_FILTER_MACHINE_COMPONENT.get()) {
                            component.setItemStack(packet.stack);
                        }
                    });
                }
            });
        }
    }
}

