/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerycreate.client;

import com.simibubi.create.content.equipment.goggles.GogglesItem;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CKinetics;
import fr.frinn.custommachinery.common.init.CustomMachineItem;
import fr.frinn.custommachinerycreate.components.ContraptionMachineComponent;
import java.util.List;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(modid="custommachinerycreate", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        CustomMachineItem.getMachine((ItemStack)event.getItemStack()).flatMap(machine -> machine.getComponentTemplates().stream().filter(template -> template instanceof ContraptionMachineComponent.Template).findFirst()).map(template -> Float.valueOf(((ContraptionMachineComponent.Template)template).stressImpact())).filter(stressImpact -> stressImpact.floatValue() != 0.0f).ifPresent(impact -> ClientEvents.addKineticStatsTooltip(impact.floatValue(), event.getToolTip()));
    }

    private static void addKineticStatsTooltip(float impact, List<Component> list) {
        CKinetics config = AllConfigs.server().kinetics;
        LangBuilder rpmUnit = CreateLang.translate((String)"generic.unit.rpm", (Object[])new Object[0]);
        boolean hasGoggles = GogglesItem.isWearingGoggles((Player)Minecraft.getInstance().player);
        CreateLang.translate((String)"tooltip.stressImpact", (Object[])new Object[0]).style(ChatFormatting.GRAY).addTo(list);
        IRotate.StressImpact impactId = (double)impact >= (Double)config.highStressImpact.get() ? IRotate.StressImpact.HIGH : ((double)impact >= (Double)config.mediumStressImpact.get() ? IRotate.StressImpact.MEDIUM : IRotate.StressImpact.LOW);
        LangBuilder builder = CreateLang.builder().add(CreateLang.text((String)TooltipHelper.makeProgressBar((int)3, (int)(impactId.ordinal() + 1))).style(impactId.getAbsoluteColor()));
        if (hasGoggles) {
            builder.add(CreateLang.number((double)impact)).text("x ").add(rpmUnit).addTo(list);
        } else {
            builder.translate("tooltip.stressImpact." + Lang.asId((String)impactId.name()), new Object[0]).addTo(list);
        }
    }
}

