/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerycreate.util;

import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import fr.frinn.custommachinerycreate.components.ContraptionMachineComponent;
import fr.frinn.custommachinerycreate.network.SUpdateFakeKineticTilePacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;

public class FakeGeneratingKineticBlockEntity
extends GeneratingKineticBlockEntity {
    private final ContraptionMachineComponent component;
    private float generatedSpeed;
    private float stressCapacity;
    private float stressImpact;

    public FakeGeneratingKineticBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, ContraptionMachineComponent component) {
        super(type, pos, state);
        this.component = component;
    }

    public void initialize() {
        super.initialize();
        if (this.generatedSpeed == 0.0f && this.stressCapacity == 0.0f && this.stressImpact == 0.0f) {
            this.remove();
        }
    }

    public void setGeneratedSpeed(float generatedSpeed) {
        this.generatedSpeed = generatedSpeed;
    }

    public void setStressCapacity(float stressCapacity) {
        this.stressCapacity = stressCapacity;
    }

    public void setStressImpact(float stressImpact) {
        this.stressImpact = stressImpact;
    }

    public float calculateAddedStressCapacity() {
        return this.stressCapacity;
    }

    public float calculateStressApplied() {
        return this.stressImpact;
    }

    public void sendData() {
        if (this.level != null && !this.level.isClientSide()) {
            CompoundTag nbt = this.writeClient(new CompoundTag(), (HolderLookup.Provider)this.level.registryAccess());
            nbt.putFloat("cm_generated_speed", this.generatedSpeed);
            nbt.putFloat("cm_stress_capacity", this.stressCapacity);
            nbt.putFloat("cm_stress_impact", this.stressImpact);
            PacketDistributor.sendToPlayersInDimension((ServerLevel)((ServerLevel)this.level), (CustomPacketPayload)new SUpdateFakeKineticTilePacket(this.worldPosition, nbt), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public float getGeneratedSpeed() {
        return this.generatedSpeed;
    }
}

