/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.crafting.IRequirementList;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientRequirement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.RecipeRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinerymekanism.Registration;
import fr.frinn.custommachinerymekanism.client.jei.heat.Heat;
import fr.frinn.custommachinerymekanism.client.jei.wrapper.HeatIngredientWrapper;
import fr.frinn.custommachinerymekanism.common.component.HeatMachineComponent;
import java.util.Collections;
import java.util.List;
import mekanism.api.heat.IHeatCapacitor;
import net.minecraft.network.chat.Component;

public record HeatRequirement(RequirementIOMode mode, double amount) implements IRequirement<HeatMachineComponent>,
IJEIIngredientRequirement<Heat>
{
    public static final NamedCodec<HeatRequirement> CODEC = NamedCodec.record(heatRequirementInstance -> heatRequirementInstance.group((App)RequirementIOMode.CODEC.fieldOf("mode").forGetter(requirement -> requirement.mode), (App)NamedCodec.doubleRange((double)0.0, (double)Double.MAX_VALUE).fieldOf("amount").forGetter(requirement -> requirement.amount)).apply((Applicative)heatRequirementInstance, HeatRequirement::new), (String)"Heat requirement");

    public RequirementType<HeatRequirement> getType() {
        return Registration.HEAT_REQUIREMENT.get();
    }

    public MachineComponentType<HeatMachineComponent> getComponentType() {
        return Registration.HEAT_MACHINE_COMPONENT.get();
    }

    public RequirementIOMode getMode() {
        return this.mode;
    }

    public boolean test(HeatMachineComponent component, ICraftingContext context) {
        double amount = context.getModifiedValue(this.amount, (IRequirement)this, null);
        if (this.getMode() == RequirementIOMode.INPUT) {
            return component.getHeatCapacitors(null).getFirst().getHeat() >= amount;
        }
        return true;
    }

    public void gatherRequirements(IRequirementList<HeatMachineComponent> list) {
        if (this.mode == RequirementIOMode.INPUT) {
            list.processDelayed(0.0, this::processInput);
        } else {
            list.processDelayed(1.0, this::processOutput);
        }
    }

    private CraftingResult processInput(HeatMachineComponent component, ICraftingContext context) {
        double amount = context.getModifiedValue(this.amount, (IRequirement)this, null);
        IHeatCapacitor capacitor = component.getHeatCapacitors(null).get(0);
        if (capacitor.getHeat() < amount) {
            return CraftingResult.error((Component)Component.translatable((String)"custommachinerymekanism.requirements.heat.error.input", (Object[])new Object[]{amount, capacitor.getHeat()}));
        }
        component.handleHeatAndUpdate(-amount);
        return CraftingResult.success();
    }

    private CraftingResult processOutput(HeatMachineComponent component, ICraftingContext context) {
        double amount = context.getModifiedValue(this.amount, (IRequirement)this, null);
        component.handleHeatAndUpdate(amount);
        return CraftingResult.success();
    }

    public List<IJEIIngredientWrapper<Heat>> getJEIIngredientWrappers(IMachineRecipe recipe, RecipeRequirement<?, ?> requirement) {
        return Collections.singletonList(new HeatIngredientWrapper(this.getMode(), this.amount, requirement.chance(), false));
    }
}

