/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.effect;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class StaffBeamEffect
extends Particle {
    private LivingEntity shooter;
    private Vector3 origin = null;
    private Vector3 targetPos;
    private static ParticleRenderType renderType = new ParticleRenderType(){
        private static ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"textures/particle/energy_beam_draconic.png");

        @Nullable
        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            textureManager.bindForSetup(texture);
            RenderSystem.disableCull();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        }
    };

    public StaffBeamEffect(ClientLevel world, LivingEntity shooter, Vector3 targetPos) {
        super(world, shooter.getX(), shooter.getY(), shooter.getZ());
        this.shooter = shooter;
        this.targetPos = targetPos;
        this.lifetime = 10;
    }

    public ParticleRenderType getRenderType() {
        return renderType;
    }

    public void tick() {
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        boolean firstPerson = this.shooter == renderInfo.getEntity() && !renderInfo.isDetached();
        Vector3 shooterPos = MathUtils.interpolateVec3((Vector3)new Vector3(this.shooter.xOld, this.shooter.yOld, this.shooter.zOld), (Vector3)new Vector3(this.shooter.position()), (double)partialTicks);
        if (firstPerson) {
            this.origin = shooterPos.add(0.0, (double)this.shooter.getEyeHeight() - 0.1125, 0.0);
            rot = (double)(this.shooter.getViewYRot(partialTicks) + 120.0f) * 0.017453292519943;
            double offset = 0.4 * Math.sin((double)(this.shooter.getXRot() + 90.0f) * 0.017453292519943);
            this.origin.add(Math.cos(rot) * offset, Math.cos((double)(this.shooter.getXRot() + 90.0f) * 0.017453292519943) * 0.4, Math.sin(rot) * offset);
        } else {
            this.origin = shooterPos.add(0.0, (double)this.shooter.getEyeHeight() - 0.65, 0.0);
            rot = (double)(this.shooter.getViewYRot(partialTicks) + 104.0f) * 0.017453292519943;
            double offset = 0.9 * Math.sin((double)(this.shooter.getXRot() + 90.0f) * 0.017453292519943);
            this.origin.add(Math.cos(rot) * offset, Math.cos((double)(this.shooter.getXRot() + 90.0f) * 0.017453292519943) * 0.9, Math.sin(rot) * offset);
        }
        float progress = Math.min(1.0f, ((float)this.age + partialTicks) / (float)this.lifetime);
        double scale = 0.05 * MathUtils.clampMap((double)progress, (double)0.0, (double)0.1, (double)0.0, (double)1.0) * MathUtils.clampMap((double)progress, (double)0.5, (double)1.0, (double)1.0, (double)0.0);
        Vector3 origin = this.origin.copy();
        Vector3 targetPos = this.targetPos.copy();
        Vec3 viewVec = renderInfo.getPosition();
        Vector3 source = origin.subtract(viewVec);
        Vector3 target = targetPos.subtract(viewVec);
        Vector3 dirVec = source.copy().subtract(target).normalize();
        Vector3 planeA = dirVec.copy().perpendicular().normalize();
        Vector3 planeB = dirVec.copy().crossProduct(planeA);
        Vector3 planeC = planeB.copy().rotate(0.7853981633974351, dirVec).normalize();
        Vector3 planeD = planeB.copy().rotate(-0.7853981633974351, dirVec).normalize();
        planeA.multiply(scale);
        planeB.multiply(scale);
        planeC.multiply(scale);
        planeD.multiply(scale);
        float dist = 0.2f * (float)Utils.getDistance((Vec3D)new Vec3D(source), (Vec3D)new Vec3D(target));
        float anim = ((float)ClientEventHandler.elapsedTicks + partialTicks) / -15.0f;
        Vector3 p1 = source.copy().add(planeA);
        Vector3 p2 = target.copy().add(planeA);
        Vector3 p3 = source.copy().subtract(planeA);
        Vector3 p4 = target.copy().subtract(planeA);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist);
        p1 = source.copy().add(planeB);
        p2 = target.copy().add(planeB);
        p3 = source.copy().subtract(planeB);
        p4 = target.copy().subtract(planeB);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist);
        p1 = source.copy().add(planeC);
        p2 = target.copy().add(planeC);
        p3 = source.copy().subtract(planeC);
        p4 = target.copy().subtract(planeC);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist);
        p1 = source.copy().add(planeD);
        p2 = target.copy().add(planeD);
        p3 = source.copy().subtract(planeD);
        p4 = target.copy().subtract(planeD);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist);
    }

    private void bufferQuad(VertexConsumer buffer, Vector3 p1, Vector3 p2, Vector3 p3, Vector3 p4, float anim, float dist) {
        buffer.addVertex((float)p1.x, (float)p1.y, (float)p1.z).setUv(0.5f, anim);
        buffer.addVertex((float)p2.x, (float)p2.y, (float)p2.z).setUv(0.5f, dist + anim);
        buffer.addVertex((float)p4.x, (float)p4.y, (float)p4.z).setUv(1.0f, dist + anim);
        buffer.addVertex((float)p3.x, (float)p3.y, (float)p3.z).setUv(1.0f, anim);
    }
}

