/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.vec.Cuboid6;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.draconicevolution.api.energy.ICrystalLink;
import com.brandon3055.draconicevolution.api.render.DERenderTypes;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.init.ItemData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BinderHandler {
    public static Map<AABB, CCModel> modelCache = new HashMap<AABB, CCModel>();

    public static boolean onBinderUse(Player player, InteractionHand hand, Level level, BlockPos blockClicked, @Nonnull ItemStack binder, Direction sideClicked) {
        BlockEntity tile = level.getBlockEntity(blockClicked);
        boolean isBound = BinderHandler.isBound(binder);
        if (tile instanceof ICrystalLink && player.isShiftKeyDown()) {
            BinderHandler.bind(binder, blockClicked, level);
            if (level.isClientSide) {
                ChatHelper.sendIndexed((Player)player, (Component)Component.translatable((String)"gui.draconicevolution.energy_net.pos_saved_to_tool").withStyle(ChatFormatting.GREEN), (UUID)TileCrystalBase.MSG_ID);
                player.swing(hand);
            }
            return true;
        }
        if (tile instanceof ICrystalLink && !isBound) {
            ChatHelper.sendIndexed((Player)player, (Component)Component.translatable((String)"gui.draconicevolution.energy_net.tool_not_bound").withStyle(ChatFormatting.RED), (UUID)TileCrystalBase.MSG_ID);
            return true;
        }
        if (isBound) {
            GlobalPos boundPos = BinderHandler.getBound(binder);
            if (boundPos.dimension() != level.dimension()) {
                ChatHelper.sendIndexed((Player)player, (Component)Component.translatable((String)"gui.draconicevolution.energy_net.link_to_other_dimension").withStyle(ChatFormatting.RED), (UUID)TileCrystalBase.MSG_ID);
                return true;
            }
            BlockPos boundLinkable = boundPos.pos();
            if (boundLinkable.equals((Object)blockClicked)) {
                ChatHelper.sendIndexed((Player)player, (Component)Component.translatable((String)"gui.draconicevolution.energy_net.link_to_self").withStyle(ChatFormatting.RED), (UUID)TileCrystalBase.MSG_ID);
                return true;
            }
            BlockEntity boundTile = level.getBlockEntity(boundLinkable);
            if (boundTile instanceof ICrystalLink) {
                if (((ICrystalLink)boundTile).binderUsed(player, blockClicked, sideClicked)) {
                    player.swing(hand);
                }
            } else {
                ChatHelper.sendIndexed((Player)player, (Component)Component.translatable((String)"gui.draconicevolution.energy_net.bound_to_invalid").withStyle(ChatFormatting.RED), (UUID)TileCrystalBase.MSG_ID);
            }
            return true;
        }
        return false;
    }

    private static boolean isBound(ItemStack stack) {
        return stack.has(ItemData.BINDER_POS);
    }

    private static void bind(ItemStack stack, BlockPos pos, Level level) {
        stack.set(ItemData.BINDER_POS, (Object)GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)pos));
    }

    private static GlobalPos getBound(ItemStack stack) {
        return (GlobalPos)stack.get(ItemData.BINDER_POS);
    }

    public static boolean clearBinder(Player player, @Nonnull ItemStack stack) {
        if (BinderHandler.isBound(stack)) {
            stack.remove(ItemData.BINDER_POS);
            ChatHelper.sendIndexed((Player)player, (Component)Component.translatable((String)"gui.draconicevolution.energy_net.pos_cleared"), (UUID)TileCrystalBase.MSG_ID);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderWorldOverlay(LocalPlayer player, PoseStack pStack, Level level, ItemStack stack, Minecraft mc, float partialTicks) {
        if (!BinderHandler.isBound(stack)) {
            return;
        }
        GlobalPos gPos = BinderHandler.getBound(stack);
        if (gPos.dimension() != level.dimension()) {
            return;
        }
        BlockPos pos = gPos.pos();
        boolean valid = level.getBlockEntity(pos) instanceof ICrystalLink;
        BlockState state = level.getBlockState(pos);
        VoxelShape shape = state.getShape((BlockGetter)level, pos);
        if (shape.isEmpty()) {
            shape = Shapes.block();
        }
        Cuboid6 cuboid6 = new Cuboid6(shape.bounds());
        MultiBufferSource.BufferSource source = Minecraft.getInstance().renderBuffers().bufferSource();
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        pStack.pushPose();
        pStack.translate(-cameraPos.x, -cameraPos.y, -cameraPos.z);
        pStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
        RenderUtils.bufferCuboidSolid((VertexConsumer)new TransformingVertexConsumer(source.getBuffer(DERenderTypes.BOX_NO_DEPTH), pStack), (Cuboid6)cuboid6, (float)(valid ? 0.0f : 1.0f), (float)(valid ? 1.0f : 0.0f), (float)0.0f, (float)0.5f);
        source.endBatch();
        RenderUtils.bufferCuboidOutline((VertexConsumer)new TransformingVertexConsumer(source.getBuffer(DERenderTypes.OUTLINE_TYPE), pStack), (Cuboid6)cuboid6, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        source.endBatch();
        pStack.popPose();
    }

    private static CCModel modelForAABB(AABB aabb) {
        if (!modelCache.containsKey(aabb)) {
            modelCache.put(aabb, CCModel.newModel((VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)24).generateBlock(0, new Cuboid6(aabb)));
        }
        return modelCache.get(aabb);
    }
}

