/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration;

import com.brandon3055.brandonscore.handlers.HandHelper;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforgespi.language.IModInfo;

public class ModHelper {
    private static Map<String, String> loadedMods = null;
    public static final boolean TINKERS_CONSTRUCT = ModList.get().isLoaded("tconstruct");
    public static final boolean AVARITIA = ModList.get().isLoaded("avaritia");
    public static final boolean ROTARYCRAFT = ModList.get().isLoaded("rotarycraft");
    public static final boolean JEI = ModList.get().isLoaded("jei");
    public static final boolean BAUBLES = ModList.get().isLoaded("baubles");
    public static final boolean ENDERSTORAGE = ModList.get().isLoaded("enderstorage");
    private static Item cleaver;
    private static Item avaritiaSword;
    private static Item bedrockSword;

    public static boolean isHoldingCleaver(Player player) {
        if (!TINKERS_CONSTRUCT) {
            return false;
        }
        if (cleaver == null) {
            cleaver = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"tconstruct", (String)"cleaver"));
        }
        return cleaver != null && HandHelper.getItem((Player)player, (Item)cleaver) != null;
    }

    public static boolean isHoldingAvaritiaSword(Player player) {
        if (!AVARITIA) {
            return false;
        }
        if (avaritiaSword == null) {
            avaritiaSword = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"avaritia", (String)"infinity_sword"));
        }
        return avaritiaSword != null && !player.getMainHandItem().isEmpty() && player.getMainHandItem().getItem().equals(avaritiaSword);
    }

    public static boolean isHoldingBedrockSword(Player player) {
        if (!ROTARYCRAFT) {
            return false;
        }
        if (bedrockSword == null) {
            bedrockSword = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"rotarycraft", (String)"rotarycraft_item_bedsword"));
        }
        return bedrockSword != null && !player.getMainHandItem().isEmpty() && player.getMainHandItem().getItem().equals(bedrockSword);
    }

    public static boolean canRemoveEnchants(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        ResourceLocation registry = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        return registry != null && !registry.getNamespace().equals("tconstruct");
    }

    public static float applyModDamageAdjustments(LivingIncomingDamageEvent event, ModuleHost host) {
        Player attacker;
        Player player = attacker = event.getSource().getEntity() instanceof Player ? (Player)event.getSource().getEntity() : null;
        if (attacker == null) {
            return event.getAmount();
        }
        if (ModHelper.isHoldingAvaritiaSword(attacker)) {
            event.getEntity().invulnerableTime = 0;
            return 300.0f;
        }
        if (event.getSource().is(DamageTypeTags.BYPASSES_ARMOR) || event.getSource().is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return event.getAmount() * 2.0f;
        }
        return event.getAmount();
    }

    public static boolean isWrench(ItemStack stack) {
        String name = String.valueOf(BuiltInRegistries.ITEM.getKey((Object)stack.getItem())).toLowerCase(Locale.ENGLISH);
        return name.contains("wrench") || name.contains("binder") || name.contains("hammer");
    }

    public static Map<String, String> getLoadedMods() {
        if (loadedMods == null) {
            loadedMods = Collections.synchronizedMap(new HashMap());
            for (IModInfo mod : ModList.get().getMods()) {
                loadedMods.put(mod.getModId(), mod.getDisplayName());
            }
        }
        return loadedMods;
    }
}

