/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.inventory;

import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public interface ModularMenuCommon {
    public List<Slot> getSlots();

    default public Stream<ItemStack> getInventoryStacks() {
        return this.getSlots().stream().map(Slot::getItem).filter(stack -> !stack.isEmpty());
    }

    public static Stream<ModuleHost> getProviders(Stream<ItemStack> stacks, HolderLookup.Provider provider) {
        return stacks.map(DECapabilities::getHost).filter(Objects::nonNull);
    }

    default public PropertyProvider findProvider(UUID identity, HolderLookup.Provider access) {
        return ModularMenuCommon.getProviders(this.getInventoryStacks(), access).filter(provider -> provider.getIdentity().equals(identity)).findFirst().orElse(null);
    }

    public static Stream<ModuleHost> getHosts(Stream<ItemStack> stacks, HolderLookup.Provider provider) {
        return stacks.map(DECapabilities::getHost).filter(Objects::nonNull);
    }

    default public ModuleHost findHost(UUID identity, HolderLookup.Provider access) {
        return ModularMenuCommon.getHosts(this.getInventoryStacks(), access).filter(provider -> provider.getIdentity().equals(identity)).findFirst().orElse(null);
    }

    default public UUID getIdentity(ItemStack stack, HolderLookup.Provider access) {
        try (ModuleHost provider = DECapabilities.getHost(stack);){
            if (!stack.isEmpty() && provider != null) {
                UUID uUID = provider.getIdentity();
                return uUID;
            }
        }
        return null;
    }
}

