/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment.damage;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.vec.Vector3;
import com.brandon3055.draconicevolution.api.modules.lib.IDamageModifier;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.client.render.effect.StaffBeamEffect;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class DefaultStaffDmgMod
implements IDamageModifier {
    @Override
    public IDamageModifier.EffectType getType() {
        return IDamageModifier.EffectType.STAFF_BEAM;
    }

    @Override
    public void addInformation(Map<Component, Component> map, @Nullable ModuleContext context, boolean stack) {
    }

    @Override
    public SoundEvent chargeSound() {
        return (SoundEvent)DESounds.STAFF_CHARGE_FIRE.get();
    }

    @Override
    public SoundEvent fireSound() {
        return SoundEvents.BLAZE_SHOOT;
    }

    @Override
    public int effectColour() {
        return 0;
    }

    @Override
    public void doDamageAndEffects(Level world, Vec3 pos, @Nullable HitResult traceResult, LivingEntity source, float baseDamage, float secondaryCharge, boolean isProjectile) {
        if (source == null) {
            return;
        }
        if (traceResult instanceof EntityHitResult) {
            pos = pos.add(0.0, (double)(((EntityHitResult)traceResult).getEntity().getBbHeight() / 2.0f), 0.0);
        } else if (traceResult != null) {
            pos = traceResult.getLocation();
        }
        Vec3 finalPos = pos;
        DraconicNetwork.sendStaffEffect(source, 0, e -> e.writeVector(new Vector3(finalPos)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleEffect(LivingEntity source, MCDataInput data) {
        Vector3 pos = data.readVector();
        ClientLevel world = (ClientLevel)source.level();
        Minecraft mc = Minecraft.getInstance();
        mc.getSoundManager().play((SoundInstance)new SimpleSoundInstance((SoundEvent)DESounds.STAFF_HIT_DEFAULT.get(), SoundSource.PLAYERS, 10.0f, 1.0f, world.random, pos.pos()));
        mc.particleEngine.add((Particle)new StaffBeamEffect(world, source, pos));
    }
}

