/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.me.matrix;

import appeng.api.config.Setting;
import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.KeyCounter;
import appeng.api.util.IConfigManager;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.MBCalculator;
import appeng.me.helpers.MachineSource;
import appeng.util.NullConfigManager;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixBase;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixCrafter;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixFunction;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixPattern;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class ClusterAssemblerMatrix
implements IAECluster {
    private final BlockPos boundsMin;
    private final BlockPos boundsMax;
    private boolean isDestroyed = false;
    private Component myName = null;
    private final List<TileAssemblerMatrixBase> tiles = new ArrayList<TileAssemblerMatrixBase>();
    private MachineSource machineSrc = null;
    private IConfigManager manager = NullConfigManager.INSTANCE;
    private final List<TileAssemblerMatrixPattern> patterns = new ArrayList<TileAssemblerMatrixPattern>();
    private final ReferenceSet<TileAssemblerMatrixCrafter> availableCrafters = new ReferenceOpenHashSet();
    private final ReferenceSet<TileAssemblerMatrixCrafter> busyCrafters = new ReferenceOpenHashSet();
    private final Reference2IntMap<TileAssemblerMatrixCrafter> crafterStatusCache = new Reference2IntOpenHashMap();
    private int speedCore = 0;

    public ClusterAssemblerMatrix(BlockPos boundsMin, BlockPos boundsMax) {
        this.boundsMin = boundsMin.immutable();
        this.boundsMax = boundsMax.immutable();
    }

    public void addCrafter(TileAssemblerMatrixCrafter crafter) {
        if (crafter.usedThread() < 8) {
            this.availableCrafters.add((Object)crafter);
        } else {
            this.busyCrafters.add((Object)crafter);
        }
    }

    public void addSpeedCore() {
        if (this.speedCore < 5) {
            ++this.speedCore;
        }
    }

    public int getSpeedCore() {
        return this.speedCore;
    }

    public IConfigManager getConfigManager() {
        return this.manager;
    }

    public int getBusyCrafterAmount() {
        int cnt = this.busyCrafters.size() * 8;
        for (TileAssemblerMatrixCrafter crafter : this.availableCrafters) {
            cnt += crafter.usedThread();
        }
        return cnt;
    }

    public void updateCrafter(TileAssemblerMatrixCrafter crafter) {
        int previous;
        if (this.crafterStatusCache.containsKey((Object)crafter) && (previous = this.crafterStatusCache.getInt((Object)crafter)) == crafter.usedThread()) {
            return;
        }
        this.crafterStatusCache.put((Object)crafter, crafter.usedThread());
        this.availableCrafters.remove((Object)crafter);
        this.busyCrafters.remove((Object)crafter);
        this.addCrafter(crafter);
    }

    public void addPattern(TileAssemblerMatrixPattern pattern) {
        this.patterns.add(pattern);
    }

    public BlockPos getBoundsMin() {
        return this.boundsMin;
    }

    public BlockPos getBoundsMax() {
        return this.boundsMax;
    }

    public void updateStatus(boolean updateGrid) {
        for (TileAssemblerMatrixBase r : this.tiles) {
            r.updateSubType(true);
        }
    }

    public List<TileAssemblerMatrixPattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    public void done() {
        TileAssemblerMatrixBase core = this.getCore();
        core.setCore(true);
        if (core.getPreviousState() != null) {
            core.setPreviousState(null);
        }
        this.manager = core.getConfigManager();
        for (Setting setting : this.manager.getSettings()) {
            this.broadcastConfig(setting, this.manager.getSetting(setting), core);
        }
        this.updateName();
    }

    public <T extends Enum<T>> void broadcastConfig(Setting<?> setting, T newValue, @Nullable TileAssemblerMatrixBase ignore) {
        for (TileAssemblerMatrixBase te : this.tiles) {
            if (ignore == te) continue;
            te.getConfigManager().putSetting(setting, newValue);
        }
    }

    @Nullable
    private TileAssemblerMatrixCrafter getAvailableCrafter() {
        if (this.availableCrafters.isEmpty()) {
            return null;
        }
        ObjectIterator objectIterator = this.availableCrafters.iterator();
        if (objectIterator.hasNext()) {
            TileAssemblerMatrixCrafter c = (TileAssemblerMatrixCrafter)((Object)objectIterator.next());
            return c;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        boolean ownsModification;
        if (this.isDestroyed) {
            return;
        }
        this.isDestroyed = true;
        boolean bl = ownsModification = !MBCalculator.isModificationInProgress();
        if (ownsModification) {
            MBCalculator.setModificationInProgress((IAECluster)this);
        }
        try {
            for (TileAssemblerMatrixBase r : this.tiles) {
                r.updateStatus(null);
            }
        }
        finally {
            if (ownsModification) {
                MBCalculator.setModificationInProgress(null);
            }
        }
    }

    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    public Iterator<TileAssemblerMatrixBase> getBlockEntities() {
        return this.tiles.iterator();
    }

    public void updateName() {
        this.myName = null;
        for (TileAssemblerMatrixBase te : this.tiles) {
            if (te.getCustomName() == null) continue;
            if (this.myName != null) {
                this.myName.copy().append(" ").append(te.getCustomName());
                continue;
            }
            this.myName = te.getCustomName().copy();
        }
    }

    public void addTileEntity(TileAssemblerMatrixBase te) {
        if (this.machineSrc == null || te.isCore()) {
            this.machineSrc = new MachineSource((IActionHost)te);
        }
        te.setCore(false);
        te.saveChanges();
        this.tiles.add(te);
        if (te instanceof TileAssemblerMatrixFunction) {
            TileAssemblerMatrixFunction fun = (TileAssemblerMatrixFunction)te;
            fun.add(this);
        }
    }

    public boolean isBusy() {
        return this.availableCrafters.isEmpty();
    }

    public boolean pushCraftingJob(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        TileAssemblerMatrixCrafter crafter = this.getAvailableCrafter();
        if (crafter == null) {
            return false;
        }
        return crafter.pushJob(patternDetails, inputHolder);
    }

    public void breakCluster() {
        TileAssemblerMatrixBase t = this.getCore();
        if (t != null) {
            t.breakCluster();
        }
    }

    private TileAssemblerMatrixBase getCore() {
        if (this.machineSrc == null) {
            return null;
        }
        return this.machineSrc.machine().orElse(null);
    }

    public IActionSource getSrc() {
        return (IActionSource)Objects.requireNonNull(this.machineSrc);
    }

    public Component getName() {
        return this.myName;
    }

    @Nullable
    public IGridNode getNode() {
        TileAssemblerMatrixBase core = this.getCore();
        return core != null ? core.getActionableNode() : null;
    }
}

