/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.me.taglist;

import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.config.EAEConfig;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public final class TagExpParser {
    private static final LoadingCache<String, Predicate<Set<String>>> COMPILED_EXPRESSION_CACHE = CacheBuilder.newBuilder().maximumSize(512L).build((CacheLoader)new CacheLoader<String, Predicate<Set<String>>>(){

        @NotNull
        public Predicate<Set<String>> load(@NotNull String key) {
            return TagExpParser.compileInternal(key);
        }
    });

    public static Predicate<Set<String>> compile(String expression) {
        if (expression == null || expression.isBlank()) {
            return tags -> false;
        }
        return (Predicate)COMPILED_EXPRESSION_CACHE.getUnchecked((Object)TagExpParser.washExpression(expression));
    }

    private static String washExpression(String expression) {
        expression = expression.replace("&&", "&");
        expression = expression.replace("||", "|");
        return expression;
    }

    public static boolean evaluate(Predicate<Set<String>> predicate, Object key) {
        Holder.Reference holder = null;
        if (key instanceof Item) {
            Item item = (Item)key;
            holder = item.builtInRegistryHolder();
        } else if (key instanceof Fluid) {
            Fluid fluid = (Fluid)key;
            holder = fluid.builtInRegistryHolder();
        }
        if (holder != null) {
            Set tagStrings = holder.tags().map(tagKey -> tagKey.location().toString()).collect(Collectors.toSet());
            return predicate.test(tagStrings);
        }
        return false;
    }

    private static Predicate<Set<String>> compileInternal(String expression) {
        try {
            List<Token> tokens = TagExpParser.tokenize(expression);
            Queue<Token> rpn = TagExpParser.convertToRPN(tokens);
            return actualTags -> {
                try {
                    return TagExpParser.evaluateRPN(rpn, actualTags);
                }
                catch (IllegalArgumentException e) {
                    if (EAEConfig.debugMode) {
                        ExtendedAE.LOGGER.error("Failed to evaluate RPN in expression: '" + expression + "' - " + e.getMessage());
                    }
                    return false;
                }
            };
        }
        catch (IllegalArgumentException e) {
            if (EAEConfig.debugMode) {
                ExtendedAE.LOGGER.error("Failed to parse tag expression: '" + expression + "' - " + e.getMessage());
            }
            return tags -> false;
        }
    }

    private static List<Token> tokenize(String expression) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        StringBuilder currentTag = new StringBuilder();
        boolean expectingOperand = true;
        boolean lastIsTag = false;
        int lp = 0;
        for (int i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (Character.isWhitespace(c)) continue;
            Operator op = Operator.fromSymbol(c);
            if (c == '(') {
                if (!expectingOperand) {
                    throw new IllegalArgumentException("Unexpected '(' at position " + i + ". Expected operator or ')'.");
                }
                TagExpParser.flushTag(currentTag, tokens);
                tokens.add(new Token(TokenType.LPAREN, "("));
                expectingOperand = true;
                ++lp;
                lastIsTag = false;
                continue;
            }
            if (c == ')') {
                if (expectingOperand && lp <= 0) {
                    throw new IllegalArgumentException("Unexpected ')' at position " + i + ". Expected operand or '('.");
                }
                TagExpParser.flushTag(currentTag, tokens);
                tokens.add(new Token(TokenType.RPAREN, ")"));
                expectingOperand = false;
                --lp;
                lastIsTag = false;
                continue;
            }
            if (op != null) {
                if (op == Operator.NOT && expectingOperand) {
                    TagExpParser.flushTag(currentTag, tokens);
                    tokens.add(new Token(op));
                    expectingOperand = true;
                } else if (op != Operator.NOT) {
                    if (lastIsTag || !expectingOperand) {
                        TagExpParser.flushTag(currentTag, tokens);
                        tokens.add(new Token(op));
                        expectingOperand = true;
                    }
                } else {
                    throw new IllegalArgumentException("Unexpected operator '" + c + "' at position " + i + ".");
                }
                lastIsTag = false;
                continue;
            }
            if (!expectingOperand) {
                throw new IllegalArgumentException("Unexpected character '" + c + "' at position " + i + ". Expected operator or ')'.");
            }
            currentTag.append(c);
            lastIsTag = true;
        }
        TagExpParser.flushTag(currentTag, tokens);
        if (tokens.isEmpty()) {
            throw new IllegalArgumentException("Expression cannot be empty.");
        }
        if (lp > 0) {
            throw new IllegalArgumentException("Missing ')' at the end of the expression.");
        }
        if (expectingOperand && ((Token)tokens.getLast()).type != TokenType.TAG && ((Token)tokens.getLast()).type != TokenType.RPAREN) {
            throw new IllegalArgumentException("Expression ended unexpectedly. Expected operand after last token.");
        }
        return tokens;
    }

    private static void flushTag(StringBuilder currentTag, List<Token> tokens) {
        if (!currentTag.isEmpty()) {
            tokens.add(new Token(TokenType.TAG, currentTag.toString()));
            currentTag.setLength(0);
        }
    }

    private static Queue<Token> convertToRPN(List<Token> tokens) {
        LinkedList<Token> outputQueue = new LinkedList<Token>();
        ArrayDeque<Token> operatorStack = new ArrayDeque<Token>();
        for (Token token : tokens) {
            switch (token.type.ordinal()) {
                case 0: {
                    outputQueue.offer(token);
                    break;
                }
                case 1: {
                    while (!operatorStack.isEmpty() && ((Token)operatorStack.peek()).type == TokenType.OPERATOR) {
                        Token topOpToken = (Token)operatorStack.peek();
                        Operator currentOp = token.op;
                        Operator topOp = topOpToken.op;
                        if ((currentOp.rightAssociative || currentOp.precedence > topOp.precedence) && (!currentOp.rightAssociative || currentOp.precedence >= topOp.precedence)) break;
                        outputQueue.offer((Token)operatorStack.pop());
                    }
                    operatorStack.push(token);
                    break;
                }
                case 2: {
                    operatorStack.push(token);
                    break;
                }
                case 3: {
                    boolean foundParen = false;
                    while (!operatorStack.isEmpty()) {
                        Token topToken = (Token)operatorStack.peek();
                        if (topToken.type == TokenType.LPAREN) {
                            operatorStack.pop();
                            foundParen = true;
                            break;
                        }
                        outputQueue.offer((Token)operatorStack.pop());
                    }
                    if (foundParen) break;
                    throw new IllegalArgumentException("Mismatched parentheses: Closing parenthesis without matching opening parenthesis.");
                }
            }
        }
        while (!operatorStack.isEmpty()) {
            Token topToken = (Token)operatorStack.peek();
            if (topToken.type == TokenType.LPAREN) {
                throw new IllegalArgumentException("Mismatched parentheses: Opening parenthesis without matching closing parenthesis.");
            }
            if (topToken.type == TokenType.OPERATOR) {
                outputQueue.offer((Token)operatorStack.pop());
                continue;
            }
            throw new IllegalStateException("Unexpected token type on operator stack: " + String.valueOf((Object)topToken.type));
        }
        return outputQueue;
    }

    private static boolean evaluateRPN(Queue<Token> rpnQueue, Set<String> actualTags) {
        ArrayDeque<Boolean> valueStack = new ArrayDeque<Boolean>();
        LinkedList<Token> queueCopy = new LinkedList<Token>(rpnQueue);
        while (!queueCopy.isEmpty()) {
            Token token = (Token)queueCopy.poll();
            if (token.type == TokenType.TAG) {
                boolean match = actualTags.stream().anyMatch(tag -> TagExpParser.matchesWildcard(token.value, tag));
                valueStack.push(match);
                continue;
            }
            if (token.type == TokenType.OPERATOR) {
                Operator op = token.op;
                try {
                    if (op == Operator.NOT) {
                        if (valueStack.isEmpty()) {
                            throw new IllegalArgumentException("Invalid expression: NOT operator requires one operand.");
                        }
                        boolean operand = (Boolean)valueStack.pop();
                        valueStack.push(!operand);
                        continue;
                    }
                    if (valueStack.size() < 2) {
                        throw new IllegalArgumentException("Invalid expression: Binary operator '" + op.symbol + "' requires two operands.");
                    }
                    boolean right = (Boolean)valueStack.pop();
                    boolean left = (Boolean)valueStack.pop();
                    switch (op.ordinal()) {
                        case 1: {
                            valueStack.push(left && right);
                            break;
                        }
                        case 3: {
                            valueStack.push(left || right);
                            break;
                        }
                        case 2: {
                            valueStack.push(left ^ right);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected binary operator: " + String.valueOf((Object)op));
                        }
                    }
                    continue;
                }
                catch (NoSuchElementException e) {
                    throw new IllegalArgumentException("Invalid RPN expression: Not enough operands for operator '" + op.symbol + "'.");
                }
            }
            throw new IllegalStateException("Unexpected token type in RPN queue: " + String.valueOf((Object)token.type));
        }
        if (valueStack.size() == 1) {
            return (Boolean)valueStack.pop();
        }
        if (valueStack.isEmpty() && rpnQueue.isEmpty()) {
            return false;
        }
        throw new IllegalArgumentException("Invalid RPN expression: Evaluation finished with " + valueStack.size() + " values on the stack (expected 1).");
    }

    private static boolean matchesWildcard(@NotNull String pattern, @NotNull String text) {
        if (pattern.equals("*") || pattern.equals(text)) {
            return true;
        }
        String regex = pattern.replace(".", "\\.").replace("(", "\\(").replace(")", "\\)").replace("[", "\\[").replace("]", "\\]").replace("{", "\\{").replace("}", "\\}").replace("?", "\\?").replace("+", "\\+").replace("^", "\\^").replace("$", "\\$").replace("|", "\\|").replace("*", ".*");
        return text.matches(regex);
    }

    private static enum Operator {
        NOT("!", 3, true),
        AND("&", 2, false),
        XOR("^", 1, false),
        OR("|", 0, false);

        final String symbol;
        final int precedence;
        final boolean rightAssociative;

        private Operator(String symbol, int precedence, boolean rightAssociative) {
            this.symbol = symbol;
            this.precedence = precedence;
            this.rightAssociative = rightAssociative;
        }

        static Operator fromSymbol(char symbol) {
            for (Operator op : Operator.values()) {
                if (op.symbol.charAt(0) != symbol) continue;
                return op;
            }
            return null;
        }
    }

    private record Token(TokenType type, String value, Operator op) {
        Token(TokenType type, String value) {
            this(type, value, null);
        }

        Token(Operator op) {
            this(TokenType.OPERATOR, op.symbol, op);
        }
    }

    private static enum TokenType {
        TAG,
        OPERATOR,
        LPAREN,
        RPAREN;

    }
}

