/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.registry.ModBlocks;

public class RopeBlock
extends IronBarsBlock {
    public static final BooleanProperty TIED_TO_BELL = BooleanProperty.create((String)"tied_to_bell");
    protected static final VoxelShape LOWER_SUPPORT_AABB = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)1.0, (double)9.0);

    public RopeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)TIED_TO_BELL, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return true;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        BlockPos posAbove = context.getClickedPos().above();
        BlockState state = super.getStateForPlacement(context);
        return state != null ? (BlockState)state.setValue((Property)TIED_TO_BELL, (Comparable)Boolean.valueOf(world.getBlockState(posAbove).getBlock() == Blocks.BELL)) : null;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        block6: {
            block5: {
                if (!((Boolean)Configuration.ENABLE_ROPE_REELING.get()).booleanValue() || !player.isSecondaryUseActive()) break block5;
                if (!player.getAbilities().mayBuild || !player.getAbilities().instabuild && !player.getInventory().add(new ItemStack((ItemLike)this.asItem()))) break block6;
                BlockPos.MutableBlockPos reelingPos = pos.mutable().move(Direction.DOWN);
                int minBuildHeight = level.getMinBuildHeight();
                while (reelingPos.getY() >= minBuildHeight) {
                    BlockState blockStateBelow = level.getBlockState((BlockPos)reelingPos);
                    if (blockStateBelow.is((Block)this)) {
                        reelingPos.move(Direction.DOWN);
                        continue;
                    }
                    reelingPos.move(Direction.UP);
                    level.destroyBlock((BlockPos)reelingPos, false, (Entity)player);
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
                break block6;
            }
            BlockPos.MutableBlockPos bellRingingPos = pos.mutable().move(Direction.UP);
            for (int i = 0; i < 24; ++i) {
                BlockState blockStateAbove = level.getBlockState((BlockPos)bellRingingPos);
                Block blockAbove = blockStateAbove.getBlock();
                if (blockAbove == Blocks.BELL) {
                    ((BellBlock)blockAbove).attemptToRing(level, (BlockPos)bellRingingPos, ((Direction)blockStateAbove.getValue((Property)BellBlock.FACING)).getClockWise());
                    return InteractionResult.SUCCESS;
                }
                if (blockAbove != ModBlocks.ROPE.get()) {
                    return InteractionResult.PASS;
                }
                bellRingingPos.move(Direction.UP);
            }
        }
        return InteractionResult.PASS;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getBlockSupportShape(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return LOWER_SUPPORT_AABB;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return useContext.getItemInHand().getItem() == this.asItem();
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        boolean tiedToBell = (Boolean)state.getValue((Property)TIED_TO_BELL);
        if (facing == Direction.UP) {
            tiedToBell = level.getBlockState(facingPos).getBlock() == Blocks.BELL;
        }
        return facing.getAxis().isHorizontal() ? (BlockState)((BlockState)state.setValue((Property)TIED_TO_BELL, (Comparable)Boolean.valueOf(tiedToBell))).setValue((Property)PROPERTY_BY_DIRECTION.get(facing), (Comparable)Boolean.valueOf(this.attachsTo(facingState, facingState.isFaceSturdy((BlockGetter)level, facingPos, facing.getOpposite())))) : super.updateShape((BlockState)state.setValue((Property)TIED_TO_BELL, (Comparable)Boolean.valueOf(tiedToBell)), facing, facingState, level, currentPos, facingPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, WEST, SOUTH, WATERLOGGED, TIED_TO_BELL});
    }
}

