/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fastitemframes.world.level.block.entity;

import fuzs.fastitemframes.FastItemFrames;
import fuzs.fastitemframes.init.ModRegistry;
import fuzs.fastitemframes.world.level.block.ItemFrameBlock;
import fuzs.puzzleslib.api.block.v1.entity.TickingBlockEntity;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HangingEntityItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;

public class ItemFrameBlockEntity
extends BlockEntity
implements TickingBlockEntity {
    static final String TAG_COLOR = FastItemFrames.id("color").toString();
    static final String TAG_ITEM_FRAME = FastItemFrames.id("item_frame").toString();
    @Nullable
    private ItemFrame itemFrame;
    @Nullable
    private CompoundTag storedTag;
    @Nullable
    private Integer color;

    public ItemFrameBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModRegistry.ITEM_FRAME_BLOCK_ENTITY.value(), pos, blockState);
    }

    public void serverTick() {
        MapId mapId;
        MapItemSavedData mapItemSavedData;
        ItemStack itemStack;
        if (this.hasLevel() && ((ServerLevel)this.getLevel()).getServer().getTickCount() % 10 == 0 && (itemStack = this.getItem()).getItem() instanceof MapItem && (mapItemSavedData = MapItem.getSavedData((MapId)(mapId = (MapId)itemStack.get(DataComponents.MAP_ID)), (Level)this.getLevel())) != null) {
            for (ServerPlayer serverPlayer : ((ServerLevel)this.getLevel()).players()) {
                mapItemSavedData.tickCarriedBy((Player)serverPlayer, itemStack);
                Packet packet = mapItemSavedData.getUpdatePacket(mapId, (Player)serverPlayer);
                if (packet == null) continue;
                serverPlayer.connection.send(packet);
            }
        }
    }

    public void load(ItemFrame itemFrame) {
        CompoundTag compoundTag = new CompoundTag();
        itemFrame.addAdditionalSaveData(compoundTag);
        this.loadItemFrame(compoundTag);
        if (ModRegistry.ITEM_FRAME_COLOR_ATTACHMENT_TYPE.has((Object)itemFrame)) {
            this.setColor((Integer)ModRegistry.ITEM_FRAME_COLOR_ATTACHMENT_TYPE.get((Object)itemFrame));
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains(TAG_ITEM_FRAME, 10)) {
            this.loadItemFrame(tag.getCompound(TAG_ITEM_FRAME));
        }
        this.color = tag.contains(TAG_COLOR, 3) ? Integer.valueOf(tag.getInt(TAG_COLOR)) : null;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        CompoundTag itemFrameTag = this.getItemFrameTag();
        if (itemFrameTag != null) {
            tag.put(TAG_ITEM_FRAME, (Tag)itemFrameTag);
        }
        if (this.color != null) {
            tag.putInt(TAG_COLOR, this.color.intValue());
        }
    }

    @Nullable
    private CompoundTag getItemFrameTag() {
        ItemFrame itemFrame = this.getEntityRepresentation();
        if (itemFrame != null) {
            CompoundTag compoundTag = new CompoundTag();
            itemFrame.addAdditionalSaveData(compoundTag);
            return compoundTag;
        }
        if (this.storedTag != null) {
            return this.storedTag;
        }
        return null;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        DyedItemColor dyedItemColor = (DyedItemColor)componentInput.get(DataComponents.DYED_COLOR);
        if (dyedItemColor != null) {
            this.color = dyedItemColor.rgb();
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        if (this.color != null) {
            components.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(this.color.intValue(), true));
        }
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove(TAG_COLOR);
    }

    public void setColor(int color) {
        if (this.color == null || this.color != color) {
            this.color = color;
        }
    }

    public OptionalInt getColor() {
        return this.color != null ? OptionalInt.of(this.color) : OptionalInt.empty();
    }

    public ItemStack getItem() {
        ItemFrame itemFrame = this.getEntityRepresentation();
        return itemFrame != null ? itemFrame.getItem() : ItemStack.EMPTY;
    }

    public boolean isInvisible() {
        return (Boolean)this.getBlockState().getValue((Property)ItemFrameBlock.INVISIBLE);
    }

    public void markUpdated() {
        if (this.hasLevel()) {
            this.getLevel().setBlock(this.getBlockPos(), this.getUpdatedBlockState(), 2);
            this.setChanged();
            this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    private BlockState getUpdatedBlockState() {
        BlockState blockState = this.getBlockState();
        ItemFrame itemFrame = this.getEntityRepresentation();
        if (itemFrame != null) {
            return (BlockState)((BlockState)((BlockState)blockState.setValue((Property)ItemFrameBlock.HAS_MAP, (Comparable)Boolean.valueOf(itemFrame.hasFramedMap()))).setValue((Property)ItemFrameBlock.DYED, (Comparable)Boolean.valueOf(this.getColor().isPresent()))).setValue((Property)ItemFrameBlock.INVISIBLE, (Comparable)Boolean.valueOf(itemFrame.isInvisible() && !itemFrame.getItem().isEmpty()));
        }
        return blockState;
    }

    @Nullable
    public ItemFrame getEntityRepresentation() {
        return this.getEntityRepresentation(false);
    }

    @Nullable
    public ItemFrame getEntityRepresentation(boolean skipInit) {
        if (this.itemFrame == null && this.hasLevel()) {
            EntityType type = ((HangingEntityItem)this.getBlockState().getBlock().asItem()).type;
            ItemFrame itemFrame = (ItemFrame)type.create(this.getLevel());
            if (!skipInit) {
                this.initItemFrame(itemFrame, this.storedTag);
            }
            this.storedTag = null;
            this.itemFrame = itemFrame;
            return this.itemFrame;
        }
        return this.itemFrame;
    }

    private void loadItemFrame(CompoundTag compoundTag) {
        ItemFrame itemFrame = this.getEntityRepresentation(true);
        if (itemFrame != null) {
            this.initItemFrame(itemFrame, compoundTag);
        } else {
            this.storedTag = compoundTag.copy();
        }
    }

    private void initItemFrame(ItemFrame itemFrame, @Nullable CompoundTag compoundTag) {
        itemFrame.setItem(ItemStack.EMPTY, false);
        BlockPos pos = this.getBlockPos();
        itemFrame.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        if (compoundTag != null) {
            itemFrame.readAdditionalSaveData(compoundTag);
        }
        itemFrame.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        itemFrame.setDirection((Direction)this.getBlockState().getValue((Property)ItemFrameBlock.FACING));
    }
}

