/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.data.outline;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import org.joml.Quaternionf;
import xfacthd.framedblocks.api.render.OutlineRenderer;
import xfacthd.framedblocks.api.render.Quaternions;
import xfacthd.framedblocks.common.blockentity.special.FramedCollapsibleBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.NullableDirection;

public final class CollapsibleBlockOutlineRenderer
implements OutlineRenderer {
    private static final Quaternionf ROTATION = Axis.YN.rotationDegrees(180.0f);

    @Override
    public void rotateMatrix(PoseStack poseStack, BlockState state) {
        poseStack.mulPose(ROTATION);
    }

    @Override
    public void draw(BlockState state, Level level, BlockPos pos, PoseStack poseStack, VertexConsumer builder) {
        NullableDirection face = (NullableDirection)((Object)state.getValue(PropertyHolder.NULLABLE_FACE));
        if (face == NullableDirection.NONE) {
            Shapes.block().forAllEdges((pMinX, pMinY, pMinZ, pMaxX, pMaxY, pMaxZ) -> OutlineRenderer.drawLine(builder, poseStack, (float)pMinX, (float)pMinY, (float)pMinZ, (float)pMaxX, (float)pMaxY, (float)pMaxZ));
        } else {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof FramedCollapsibleBlockEntity)) {
                return;
            }
            FramedCollapsibleBlockEntity be = (FramedCollapsibleBlockEntity)blockEntity;
            float v0 = 1.0f - (float)be.getVertexOffset(0) / 16.0f;
            float v1 = 1.0f - (float)be.getVertexOffset(1) / 16.0f;
            float v2 = 1.0f - (float)be.getVertexOffset(2) / 16.0f;
            float v3 = 1.0f - (float)be.getVertexOffset(3) / 16.0f;
            Direction faceDir = face.toDirection().getOpposite();
            poseStack.pushPose();
            poseStack.translate(0.5, 0.5, 0.5);
            if (faceDir == Direction.UP) {
                poseStack.mulPose(Quaternions.XP_180);
            } else if (faceDir != Direction.DOWN) {
                poseStack.mulPose(OutlineRenderer.YN_DIR[faceDir.getOpposite().get2DDataValue()]);
                poseStack.mulPose(Quaternions.XN_90);
            }
            poseStack.translate(-0.5, -0.5, -0.5);
            OutlineRenderer.drawLine(builder, poseStack, 0.0f, v2, 0.0f, 0.0f, v3, 1.0f);
            OutlineRenderer.drawLine(builder, poseStack, 0.0f, v2, 0.0f, 1.0f, v1, 0.0f);
            OutlineRenderer.drawLine(builder, poseStack, 1.0f, v1, 0.0f, 1.0f, v0, 1.0f);
            OutlineRenderer.drawLine(builder, poseStack, 0.0f, v3, 1.0f, 1.0f, v0, 1.0f);
            OutlineRenderer.drawLine(builder, poseStack, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
            OutlineRenderer.drawLine(builder, poseStack, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            OutlineRenderer.drawLine(builder, poseStack, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f);
            OutlineRenderer.drawLine(builder, poseStack, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f);
            OutlineRenderer.drawLine(builder, poseStack, 1.0f, 0.0f, 1.0f, 1.0f, v0, 1.0f);
            OutlineRenderer.drawLine(builder, poseStack, 1.0f, 0.0f, 0.0f, 1.0f, v1, 0.0f);
            OutlineRenderer.drawLine(builder, poseStack, 0.0f, 0.0f, 0.0f, 0.0f, v2, 0.0f);
            OutlineRenderer.drawLine(builder, poseStack, 0.0f, 0.0f, 1.0f, 0.0f, v3, 1.0f);
            poseStack.popPose();
        }
    }

    @Override
    public void draw(BlockState state, PoseStack poseStack, VertexConsumer builder) {
        throw new UnsupportedOperationException();
    }
}

