/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.torch;

import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Vector3f;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.ClientUtils;
import xfacthd.framedblocks.api.util.Utils;

public class FramedWallTorchGeometry
extends Geometry {
    private static final Vector3f ROTATION_ORIGIN = new Vector3f(0.0f, 0.21875f, 0.5f);
    private static final float MIN = 0.4375f;
    private static final float MAX = 0.5625f;
    private static final float TOP = 0.71875f;
    private static final float BOTTOM = 0.78125f;
    private final BlockState state;
    private final BakedModel baseModel;
    private final float yAngle;

    public FramedWallTorchGeometry(GeometryFactory.Context ctx) {
        this.state = ctx.state();
        this.baseModel = ctx.baseModel();
        this.yAngle = 270.0f - ((Direction)ctx.state().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot();
    }

    @Override
    public ChunkRenderTypeSet getAdditionalRenderTypes(RandomSource rand, ModelData extraData) {
        return ModelUtils.getRenderTypes(Blocks.WALL_TORCH.defaultBlockState(), rand, extraData);
    }

    @Override
    public void getAdditionalQuads(QuadMap quadMap, RandomSource rand, ModelData extraData, RenderType renderType) {
        List quads = this.baseModel.getQuads(this.state, null, rand, extraData, renderType);
        for (BakedQuad quad : quads) {
            if (ClientUtils.isDummyTexture(quad)) continue;
            quadMap.get(null).add(quad);
        }
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (Utils.isY(quadDir)) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(0.4375f, 0.4375f, 0.5625f, 0.5625f)).apply(Modifiers.setPosition(quadDir == Direction.UP ? 0.71875f : 0.78125f)).apply(Modifiers.offset(Direction.WEST, 0.5f)).apply(FramedWallTorchGeometry.applyRotation(this.yAngle)).export(quadMap.get(null));
        } else {
            boolean xAxis = Utils.isX(quadDir);
            boolean east = quadDir == Direction.EAST;
            QuadModifier.of(quad).apply(Modifiers.cutSide(0.4375f, 0.0f, 0.5625f, 0.5f)).applyIf(Modifiers.setPosition(east ? 0.0625f : 1.0625f), xAxis).applyIf(Modifiers.setPosition(0.5625f), !xAxis).applyIf(Modifiers.offset(Direction.WEST, 0.5f), !xAxis).apply(Modifiers.offset(Direction.UP, 0.21875f)).apply(FramedWallTorchGeometry.applyRotation(this.yAngle)).export(quadMap.get(null));
        }
    }

    @Override
    public boolean useSolidNoCamoModel() {
        return true;
    }

    public static QuadModifier.Modifier applyRotation(float yAngle) {
        return data -> Modifiers.rotate(Direction.Axis.Z, ROTATION_ORIGIN, -22.5f, false).accept(data) && Modifiers.rotateCentered(Direction.Axis.Y, yAngle, false).accept(data);
    }
}

