/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.utils.Color4;
import blusunrize.immersiveengineering.common.entities.RevolvershotEntity;
import blusunrize.immersiveengineering.common.items.bullets.IEBullets;
import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RevolvershotFlareEntity
extends RevolvershotEntity {
    private BlockPos lightPos;

    public RevolvershotFlareEntity(EntityType<RevolvershotFlareEntity> type, Level world) {
        super((EntityType<? extends RevolvershotEntity>)type, world);
        this.setTickLimit(400);
    }

    public RevolvershotFlareEntity(Level world, double x, double y, double z, double ax, double ay, double az, Color4 color) {
        super((EntityType<? extends RevolvershotEntity>)((EntityType)IEEntityTypes.FLARE_REVOLVERSHOT.get()), world, null, x, y, z, ax, ay, az, IEBullets.FLARE_TYPE, color);
        this.setTickLimit(400);
    }

    public RevolvershotFlareEntity(Level world, LivingEntity living, double ax, double ay, double az, Color4 color) {
        super((EntityType<? extends RevolvershotEntity>)((EntityType)IEEntityTypes.FLARE_REVOLVERSHOT.get()), world, living, ax, ay, az, IEBullets.FLARE_TYPE, color);
        this.setTickLimit(400);
    }

    public Color4 getColour() {
        return this.getBullet().getFor(IEBullets.FLARE_TYPE);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            Color4 color = this.getColour();
            this.level().addParticle((ParticleOptions)new DustParticleOptions(color.toVector3f(), 1.0f), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            if (this.tickCount > 40) {
                for (int i = 0; i < 20; ++i) {
                    Vec3 v = new Vec3(ApiUtils.RANDOM.nextDouble() - 0.5, ApiUtils.RANDOM.nextDouble() - 0.5, ApiUtils.RANDOM.nextDouble() - 0.5);
                    this.level().addParticle((ParticleOptions)new DustParticleOptions(color.toVector3f(), 1.0f), this.getX() + v.x, this.getY() + v.y, this.getZ() + v.z, v.x / 10.0, v.y / 10.0, v.z / 10.0);
                }
            }
        }
        if (this.tickCount == 40) {
            this.setDeltaMovement(0.0, -0.1, 0.0);
            this.spawnParticles();
            this.lightPos = this.blockPosition();
            for (int i = 0; i < 128; ++i) {
                if (!this.level().isEmptyBlock(this.lightPos)) {
                    this.lightPos = this.lightPos.above(6);
                    break;
                }
                this.lightPos = this.lightPos.below();
            }
        }
    }

    @Override
    public void onHit(HitResult mop) {
        if (this.tickCount <= 40) {
            if (!this.level().isClientSide) {
                if (mop instanceof EntityHitResult) {
                    Entity hit = ((EntityHitResult)mop).getEntity();
                    if (!hit.fireImmune()) {
                        hit.igniteForSeconds(8.0f);
                    }
                } else if (mop instanceof BlockHitResult) {
                    BlockHitResult blockRTR = (BlockHitResult)mop;
                    BlockPos pos = blockRTR.getBlockPos().relative(blockRTR.getDirection());
                    if (this.level().isEmptyBlock(pos)) {
                        this.level().setBlockAndUpdate(pos, Blocks.FIRE.defaultBlockState());
                    }
                }
            }
            this.spawnParticles();
        }
        this.discard();
    }

    private void spawnParticles() {
        for (int i = 0; i < 80; ++i) {
            Vec3 v = new Vec3((ApiUtils.RANDOM.nextDouble() - 0.5) * (double)i > 40.0 ? 2.0 : 1.0, (ApiUtils.RANDOM.nextDouble() - 0.5) * (double)i > 40.0 ? 2.0 : 1.0, (ApiUtils.RANDOM.nextDouble() - 0.5) * (double)i > 40.0 ? 2.0 : 1.0);
            this.level().addParticle((ParticleOptions)new DustParticleOptions(this.getColour().toVector3f(), 1.0f), this.getX() + v.x, this.getY() + v.y, this.getZ() + v.z, v.x / 10.0, v.y / 10.0, v.z / 10.0);
        }
    }
}

