/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.util.Utils;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageBirthdayParty(int entityID) implements IMessage
{
    public static final CustomPacketPayload.Type<MessageBirthdayParty> ID = IMessage.createType("birthday_party");
    public static final StreamCodec<ByteBuf, MessageBirthdayParty> CODEC = ByteBufCodecs.INT.map(MessageBirthdayParty::new, MessageBirthdayParty::entityID);

    @Override
    public void process(IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity entity;
            Level world = ImmersiveEngineering.proxy.getClientWorld();
            if (world != null && (entity = world.getEntity(this.entityID)) != null && entity instanceof LivingEntity) {
                world.createFireworks(entity.getX(), entity.getY(), entity.getZ(), 0.0, 0.0, 0.0, Utils.getRandomFireworkExplosion(ApiUtils.RANDOM));
                entity.getPersistentData().putBoolean("headshot", true);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

