/*
 * Decompiled with CFR 0.152.
 */
package giselle.jei_mekanism_multiblocks.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import giselle.jei_mekanism_multiblocks.client.GuiHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class CheckBoxWidget
extends AbstractButton {
    private final List<Consumer<Boolean>> selectedChangedHandlers = new ArrayList<Consumer<Boolean>>();
    private boolean selected;
    private boolean shadow;

    public CheckBoxWidget(int pX, int pY, int pWidth, int pHeight, Component pMessage, boolean pSelected) {
        super(pX, pY, pWidth, pHeight, pMessage);
        this.selected = pSelected;
        this.setFGColor(0x404040);
        this.shadow = false;
    }

    public void addSelectedChangedHandler(Consumer<Boolean> handler) {
        this.selectedChangedHandlers.add(handler);
    }

    public void onPress() {
        this.setSelected(!this.isSelected());
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        if (this.isSelected() != selected) {
            this.selected = selected;
            for (Consumer<Boolean> handler : this.selectedChangedHandlers) {
                handler.accept(selected);
            }
        }
    }

    public void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int checkerLength = this.height;
        pGuiGraphics.blit(GuiHelper.WIDGETS_LOCATION, this.getX(), this.getY(), checkerLength, checkerLength, 0.0f + (this.isHoveredOrFocused() ? 10.0f : 0.0f), 16.0f + (this.selected ? 10.0f : 0.0f), 10, 10, 256, 256);
        int j = this.getFGColor();
        GuiHelper.drawScaledText(pGuiGraphics, this.getMessage(), this.getX() + checkerLength + 1, this.getY(), this.width - checkerLength - 1, j | Mth.ceil((float)(this.alpha * 255.0f)) << 24, this.isShadow());
    }

    protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
        this.defaultButtonNarrationText(pNarrationElementOutput);
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }
}

