/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import snownee.kiwi.Kiwi;

public class ModContext {
    public static final Map<String, ModContext> ALL_CONTEXTS = Maps.newHashMap();
    public ModContainer modContainer;

    public static ModContext get(String modid) {
        if (ALL_CONTEXTS.containsKey(modid)) {
            return ALL_CONTEXTS.get(modid);
        }
        ModContext context = new ModContext(modid);
        ALL_CONTEXTS.put(modid, context);
        return context;
    }

    private ModContext(String modid) {
        Objects.requireNonNull(modid, "Cannot get name of kiwi module.");
        try {
            this.modContainer = (ModContainer)ModList.get().getModContainerById(modid).orElseThrow();
        }
        catch (NoSuchElementException e) {
            Kiwi.LOGGER.error("Cannot find mod container for modid {}", (Object)modid);
        }
    }

    public void setActiveContainer() {
        ModLoadingContext.get().setActiveContainer(this.modContainer);
    }
}

