/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.contributor.impl.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

public class PlanetModel<T extends LivingEntity>
extends AgeableListModel<T> {
    private final ModelPart largePlanet;
    private final ModelPart smallPlanet;

    public PlanetModel(LayerDefinition definition) {
        ModelPart root = definition.bakeRoot();
        this.largePlanet = root.getChild("large");
        this.smallPlanet = root.getChild("small");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.getRoot();
        root.addOrReplaceChild("large", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -36.0f, -2.0f, 4.0f, 4.0f, 4.0f).texOffs(-9, 8).addBox(-4.5f, -34.0f, -4.5f, 9.0f, 0.0f, 9.0f), PartPose.offset((float)0.0f, (float)20.0f, (float)-20.0f));
        root.addOrReplaceChild("small", CubeListBuilder.create().texOffs(16, 0).addBox(-1.5f, -35.0f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)20.0f, (float)16.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.largePlanet, (Object)this.smallPlanet);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.largePlanet.yRot = -ageInTicks / 10.0f;
        this.smallPlanet.yRot = -ageInTicks / 6.0f;
    }
}

