/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.builder;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Queue;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.customization.block.KBlockUtils;
import snownee.kiwi.customization.builder.FacingLimitation;

public record BlockSpread(Type type, FacingLimitation facingLimitation, int maxDistance) {
    public static final Codec<BlockSpread> CODEC = Codec.withAlternative((Codec)RecordCodecBuilder.create(instance -> instance.group((App)Type.CODEC.fieldOf("type").forGetter(BlockSpread::type), (App)StringRepresentable.fromEnum(FacingLimitation::values).optionalFieldOf("facing_limit", (Object)FacingLimitation.None).forGetter(BlockSpread::facingLimitation), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("max_distance", (Object)16).forGetter(BlockSpread::maxDistance)).apply((Applicative)instance, BlockSpread::create)), (Codec)Type.CODEC.xmap(type -> BlockSpread.create(type, FacingLimitation.None, 16), BlockSpread::type));
    private static final Interner<BlockSpread> INTERNER = Interners.newStrongInterner();

    public static BlockSpread create(Type type, FacingLimitation facingLimitation, int maxDistance) {
        return (BlockSpread)INTERNER.intern((Object)new BlockSpread(type, facingLimitation, maxDistance));
    }

    public List<BlockPos> collect(UseOnContext context, Predicate<BlockState> blockPredicate, @Nullable BiConsumer<BlockPos, BlockState> blockConsumer) {
        return this.collect((BlockGetter)context.getLevel(), context.getClickedPos(), Objects.requireNonNull(context.getPlayer()), blockPredicate, blockConsumer);
    }

    public List<BlockPos> collect(BlockGetter level, BlockPos origin, Player player, Predicate<BlockState> blockPredicate, @Nullable BiConsumer<BlockPos, BlockState> blockConsumer) {
        BlockState originalBlock = level.getBlockState(origin);
        if (!blockPredicate.test(originalBlock)) {
            return List.of();
        }
        Direction direction = player.getDirection();
        Direction originalDirection = null;
        try {
            String s = KBlockUtils.getValueString(originalBlock, "facing");
            originalDirection = Direction.valueOf((String)s.toUpperCase(Locale.ENGLISH));
        }
        catch (Exception s) {
            // empty catch block
        }
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (originalDirection == null || this.facingLimitation.test(originalDirection, direction)) {
                    yield this.collectPlane(level, origin, blockPredicate, direction, direction.getClockWise(), blockConsumer);
                }
                yield List.of();
            }
            case 1 -> {
                float yRot = player.getYRot() / 90.0f % 1.0f;
                boolean forcedDirection = yRot < 0.15f || yRot > 0.85f;
                List<Object> list = List.of();
                if (originalDirection == null || this.facingLimitation.test(originalDirection, direction)) {
                    list = this.collectPlane(level, origin, blockPredicate, direction, Direction.UP, blockConsumer);
                }
                List<Object> list2 = List.of();
                if (!forcedDirection && (originalDirection == null || this.facingLimitation.test(originalDirection, direction.getClockWise()))) {
                    list2 = this.collectPlane(level, origin, blockPredicate, direction.getClockWise(), Direction.UP, blockConsumer);
                }
                if (list.size() != list2.size()) {
                    if (list.size() > list2.size()) {
                        yield list;
                    }
                    yield list2;
                }
                yield list;
            }
            case 2 -> this.collectPlaneXYZ(level, origin, blockPredicate, player);
        };
    }

    private List<BlockPos> collectPlaneXYZ(BlockGetter level, BlockPos origin, Predicate<BlockState> blockPredicate, Player player) {
        throw new NotImplementedException();
    }

    private List<BlockPos> collectPlane(BlockGetter level, BlockPos origin, Predicate<BlockState> blockPredicate, Direction direction, Direction direction2, @Nullable BiConsumer<BlockPos, BlockState> blockConsumer) {
        ArrayList list = Lists.newArrayList((Object[])new BlockPos[]{origin});
        PlacePosIterator iterator = new PlacePosIterator(origin, this.maxDistance, direction, direction2);
        while (iterator.hasNext()) {
            BlockPos next = iterator.next();
            BlockState blockState = level.getBlockState(next);
            if (!blockPredicate.test(blockState)) continue;
            if (blockConsumer != null) {
                blockConsumer.accept(next, blockState);
            }
            list.add(next);
            iterator.add(next, null);
        }
        return list;
    }

    public static enum Type implements StringRepresentable
    {
        PLANE_Y,
        PLANE_XZ,
        PLANE_XYZ;

        public static final Codec<Type> CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
        }
    }

    static class PlacePosIterator
    extends PosIterator {
        final Direction direction;
        final Direction direction2;

        PlacePosIterator(BlockPos origin, int maxDistance, Direction direction, Direction direction2) {
            super(origin, maxDistance);
            this.direction = direction;
            this.direction2 = direction2;
        }

        @Override
        public Stream<BlockPos> listPossibleNext(BlockPos cur, @Nullable BlockPos from) {
            Stream.Builder<BlockPos> builder = Stream.builder();
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    BlockPos next;
                    if (i == 0 && j == 0 || (next = cur.relative(this.direction, i).relative(this.direction2, j)).equals((Object)from)) continue;
                    builder.accept(next);
                }
            }
            return builder.build();
        }
    }

    static abstract class PosIterator
    implements Iterator<BlockPos> {
        final LongSet visited = new LongAVLTreeSet();
        final Queue<BlockPos> queue = Lists.newLinkedList();
        final BlockPos origin;
        final int maxDistance;

        PosIterator(BlockPos origin, int maxDistance) {
            this.origin = origin;
            this.maxDistance = maxDistance;
        }

        @Override
        public boolean hasNext() {
            if (this.visited.isEmpty()) {
                this.add(this.origin, null);
            }
            return !this.queue.isEmpty();
        }

        @Override
        public BlockPos next() {
            return Objects.requireNonNull(this.queue.poll());
        }

        public void add(BlockPos cur, @Nullable BlockPos from) {
            if (this.origin.distManhattan((Vec3i)cur) > this.maxDistance) {
                return;
            }
            this.visited.add(cur.asLong());
            this.listPossibleNext(cur, from).filter(pos -> {
                long l = pos.asLong();
                if (this.visited.contains(l)) {
                    return false;
                }
                this.visited.add(l);
                return true;
            }).forEach(this.queue::add);
        }

        public abstract Stream<BlockPos> listPossibleNext(BlockPos var1, @Nullable BlockPos var2);
    }
}

