/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import snownee.kiwi.KiwiGO;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.KiwiModules;

public interface GameObjectLookup {
    public static <T> Stream<T> all(ResourceKey<Registry<T>> registryKey, String modId) {
        return GameObjectLookup.allHolders(registryKey, modId).map(Holder::value);
    }

    public static <T> Stream<Holder.Reference<T>> allHolders(ResourceKey<Registry<T>> registryKey, String modId) {
        Registry registry = Objects.requireNonNull((Registry)BuiltInRegistries.REGISTRY.get(registryKey.location()));
        return registry.holders().filter($ -> $.key().location().getNamespace().equals(modId));
    }

    public static <T> Stream<OptionalEntry<T>> fromModules(ResourceKey<Registry<T>> registryKey, String ... ids) {
        return Stream.of(ids).map(ResourceLocation::parse).map(KiwiModules::get).mapMulti(($, consumer) -> {
            boolean optional = $.module.getClass().getDeclaredAnnotation(KiwiModule.Optional.class) != null;
            $.getRegistryEntries(registryKey).map($$ -> new OptionalEntry($$, optional)).forEach((Consumer<OptionalEntry>)consumer);
        });
    }

    public record OptionalEntry<T>(KiwiGO<T> holder, boolean optional) {
    }
}

