/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.action;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.util.codec.KCodecs;
import snownee.lychee.context.ActionContext;
import snownee.lychee.util.BoundsExtensions;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.action.CompoundAction;
import snownee.lychee.util.action.Job;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.action.PostActionType;
import snownee.lychee.util.action.PostActionTypes;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.json.JsonPointer;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record RandomSelect(PostActionCommonProperties commonProperties, List<Entry> entries, int totalWeight, int emptyWeight, MinMaxBounds.Ints rolls, boolean canRepeat, boolean hidden, boolean preventSync) implements CompoundAction,
PostAction
{
    public RandomSelect(PostActionCommonProperties commonProperties, List<Entry> entries, int emptyWeight, MinMaxBounds.Ints rolls) {
        this(commonProperties, entries, entries.stream().mapToInt(it -> it.weight).sum() + emptyWeight, emptyWeight, rolls, entries.stream().allMatch(it -> it.action().repeatable()), commonProperties.hidden() || entries.stream().allMatch(it -> it.action().hidden()), entries.stream().allMatch(it -> it.action().preventSync()));
        Preconditions.checkArgument((this.totalWeight > 0 ? 1 : 0) != 0, (Object)"Total weight must be positive");
    }

    public PostActionType<RandomSelect> type() {
        return PostActionTypes.RANDOM;
    }

    @Override
    public void apply(@Nullable ILycheeRecipe<?> recipe, LycheeContext context, int times) {
        RandomSource randomSource = context.get(LycheeContextKey.RANDOM);
        if ((times *= BoundsExtensions.random(this.rolls, randomSource)) == 0) {
            return;
        }
        ArrayList validActions = Lists.newArrayList();
        int[] validWeights = new int[this.entries.size()];
        int totalWeights = 0;
        for (Entry entry : this.entries) {
            if (entry.action.test(recipe, context, 1) != 1) continue;
            validWeights[validActions.size()] = entry.weight;
            validActions.add(entry.action);
            totalWeights += entry.weight;
        }
        if (validActions.isEmpty()) {
            return;
        }
        totalWeights += this.emptyWeight;
        int[] childTimes = new int[validActions.size()];
        for (int i = 0; i < times; ++i) {
            int index = this.getRandomEntry(randomSource, validWeights, totalWeights);
            if (index < 0) continue;
            int n = index;
            childTimes[n] = childTimes[n] + 1;
        }
        ActionContext actionContext = context.get(LycheeContextKey.ACTION);
        for (int i = 0; i < validActions.size(); ++i) {
            if (childTimes[i] <= 0) continue;
            actionContext.jobs.offer(new Job((PostAction)validActions.get(i), childTimes[i]));
        }
    }

    private int getRandomEntry(RandomSource random, int[] weights, int totalWeights) {
        int j = random.nextInt(totalWeights);
        for (int i = 0; i < weights.length; ++i) {
            if ((j -= weights[i]) >= 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<ItemStack> getOutputItems() {
        return this.entries.stream().map(it -> it.action.getOutputItems()).flatMap(Collection::stream).toList();
    }

    @Override
    public List<BlockPredicate> getOutputBlocks() {
        return this.entries.stream().map(it -> it.action.getOutputBlocks()).flatMap(Collection::stream).toList();
    }

    @Override
    public Component getDisplayName() {
        if (this.entries.size() == 1 && this.emptyWeight == 0) {
            return Component.literal((String)"%s \u00d7 %s".formatted(this.entries.getFirst().action.getDisplayName().getString(), BoundsExtensions.getPlainDescription(this.rolls).getString()));
        }
        return CommonProxy.getCycledItem(this.entries, this.entries.getFirst(), (int)1000).action.getDisplayName();
    }

    @Override
    public void getUsedPointers(@Nullable ILycheeRecipe<?> recipe, Consumer<JsonPointer> consumer) {
        for (Entry entry : this.entries) {
            entry.action.getUsedPointers(recipe, consumer);
        }
    }

    @Override
    public Stream<PostAction> getChildActions() {
        return this.entries.stream().map(it -> it.action);
    }

    public record Entry(PostAction action, int weight) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PostAction.MAP_CODEC.forGetter(Entry::action), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("weight", (Object)1).forGetter(Entry::weight)).apply((Applicative)instance, Entry::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Entry> STREAM_CODEC = StreamCodec.composite(PostAction.STREAM_CODEC, Entry::action, (StreamCodec)ByteBufCodecs.VAR_INT, Entry::weight, Entry::new);
    }

    public static class Type
    implements PostActionType<RandomSelect> {
        public static final MapCodec<RandomSelect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PostActionCommonProperties.MAP_CODEC.forGetter(RandomSelect::commonProperties), (App)ExtraCodecs.nonEmptyList((Codec)KCodecs.compactList(Entry.CODEC)).fieldOf("entries").forGetter(RandomSelect::entries), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("empty_weight", (Object)0).forGetter(RandomSelect::emptyWeight), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("rolls", (Object)BoundsExtensions.ONE).forGetter(RandomSelect::rolls)).apply((Applicative)instance, RandomSelect::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, RandomSelect> STREAM_CODEC = StreamCodec.composite(PostActionCommonProperties.STREAM_CODEC, RandomSelect::commonProperties, (StreamCodec)Entry.STREAM_CODEC.apply(ByteBufCodecs.list()), RandomSelect::entries, (StreamCodec)ByteBufCodecs.VAR_INT, RandomSelect::emptyWeight, BoundsExtensions.INT_STREAM_CODEC, RandomSelect::rolls, RandomSelect::new);

        @Override
        public MapCodec<RandomSelect> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, RandomSelect> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

