/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.category;

import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import snownee.lychee.RecipeTypes;
import snownee.lychee.client.gui.AllGuiTextures;
import snownee.lychee.client.gui.InteractiveRenderElement;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.compat.recipeviewer.category.DecorationMapBuilder;
import snownee.lychee.compat.recipeviewer.category.ItemAndBlockCategory;
import snownee.lychee.recipes.BlockInteractingRecipe;
import snownee.lychee.util.VectorExtensions;

public class BlockInteractingRecipeCategory
extends ItemAndBlockCategory<BlockInteractingRecipe> {
    private static final float INPUT_INGREDIENT_X = 22.0f;
    public static final Vector2fc INPUT_BLOCK_POSITION = VectorExtensions.offsetX(ItemAndBlockCategory.INPUT_BLOCK_POSITION, 34.0f);
    public static final Vector2fc METHOD_POSITION = VectorExtensions.offsetX(ItemAndBlockCategory.METHOD_POSITION, 40.0f);
    public static final Vector2fc INFO_POSITION = new Vector2f(18.0f, 40.0f);

    @Override
    public void setupDecorations(DecorationMapBuilder<BlockInteractingRecipe> mapBuilder) {
        super.setupDecorations(mapBuilder);
        mapBuilder.put("method", (builder, recipeHolder) -> {
            BlockInteractingRecipe recipe = (BlockInteractingRecipe)recipeHolder.value();
            AllGuiTextures icon = recipe.getType() == RecipeTypes.BLOCK_CLICKING ? AllGuiTextures.LEFT_CLICK : AllGuiTextures.RIGHT_CLICK;
            builder.addElement((RenderElement)((RenderElement)InteractiveRenderElement.create(icon).onTooltip(() -> List.of(Component.translatable((String)Util.makeDescriptionId((String)"tip", (ResourceLocation)BuiltInRegistries.RECIPE_SERIALIZER.getKey((Object)recipe.getSerializer()))))).withSize(16)).at(this.methodPosition()));
        });
    }

    @Override
    public Vector2fc infoPosition(BlockInteractingRecipe recipe) {
        return INFO_POSITION;
    }

    @Override
    public Vector2fc inputBlockPosition() {
        return INPUT_BLOCK_POSITION;
    }

    @Override
    public Vector2fc methodPosition() {
        return METHOD_POSITION;
    }

    @Override
    public float inputIngredientX() {
        return 22.0f;
    }
}

