/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.emi.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ItemEmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.Block;
import org.joml.Vector2fc;
import snownee.lychee.RecipeTypes;
import snownee.lychee.action.DropItem;
import snownee.lychee.action.input.DamageItem;
import snownee.lychee.action.input.PreventDefault;
import snownee.lychee.client.gui.InteractiveRenderElement;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.client.gui.ScreenElement;
import snownee.lychee.client.gui.WrapperRenderElement;
import snownee.lychee.compat.recipeviewer.IngredientInfo;
import snownee.lychee.compat.recipeviewer.RVs;
import snownee.lychee.compat.recipeviewer.SlotType;
import snownee.lychee.compat.recipeviewer.category.RvCategory;
import snownee.lychee.compat.recipeviewer.category.RvCategoryInstance;
import snownee.lychee.compat.recipeviewer.category.RvCategoryLayoutBuilder;
import snownee.lychee.compat.recipeviewer.category.RvCategoryWidgetBuilder;
import snownee.lychee.compat.recipeviewer.emi.category.RvCategoryAdapter;
import snownee.lychee.compat.recipeviewer.emi.element.EmiWidgetAdapter;
import snownee.lychee.compat.recipeviewer.emi.element.LycheeSlotWidget;
import snownee.lychee.compat.recipeviewer.emi.ingredient.PostActionEmiStack;
import snownee.lychee.ui.TextElementRenderer;
import snownee.lychee.util.action.ActionRenderer;
import snownee.lychee.util.action.CompoundAction;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionDisplay;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.ILycheeRecipe;

public class EmiRecipeAdapter<R extends ILycheeRecipe<LycheeContext>>
implements EmiRecipe {
    private final RvCategoryAdapter<R> category;
    private final RecipeHolder<R> recipe;
    protected List<EmiIngredient> inputs = Lists.newArrayList();
    protected List<Pair<IngredientInfo, EmiIngredient>> ingredients = Lists.newArrayList();
    protected List<EmiIngredient> catalysts = Lists.newArrayList();
    protected List<EmiStack> outputs = Lists.newArrayList();

    public EmiRecipeAdapter(RvCategoryAdapter<R> category, RecipeHolder<R> recipeHolder) {
        this.category = category;
        this.recipe = recipeHolder;
        ILycheeRecipe recipe = (ILycheeRecipe)recipeHolder.value();
        List<IngredientInfo> ingredients = RVs.generateShapelessInputs(recipe);
        for (IngredientInfo ingredient : ingredients) {
            EmiIngredient emiIngredient = EmiIngredient.of((Ingredient)ingredient.ingredient, (long)ingredient.count);
            if (ingredient.relatedAction != null) {
                for (EmiStack emiStack : emiIngredient.getEmiStacks()) {
                    ItemStack itemStack = emiStack.getItemStack();
                    if (itemStack.isEmpty() || (itemStack = ingredient.relatedAction.transformRemainder(itemStack, recipe)).isEmpty()) continue;
                    emiStack.setRemainder(EmiStack.of((ItemStack)itemStack));
                }
            }
            this.ingredients.add((Pair<IngredientInfo, EmiIngredient>)Pair.of((Object)ingredient, (Object)emiIngredient));
            if (ingredient.type == SlotType.CATALYST && ingredient.relatedAction instanceof PreventDefault) {
                this.catalysts.add(emiIngredient);
                continue;
            }
            this.inputs.add(emiIngredient);
        }
        List<EmiIngredient> list = recipe.getType() == RecipeTypes.BLOCK_EXPLODING ? this.inputs : (RvCategory.needConsumeBlockInput(recipe) ? this.inputs : this.catalysts);
        recipe.getBlockInputs().stream().map(BlockPredicateExtensions::matchedFluids).flatMap(Collection::stream).distinct().map(EmiStack::of).forEach(list::add);
        recipe.getBlockInputs().stream().map(BlockPredicateExtensions::matchedBlocks).flatMap(Collection::stream).map(Block::asItem).filter(it -> !it.equals(Items.AIR)).distinct().map(EmiStack::of).forEach(list::add);
        recipe.allActions().filter(it -> !it.hidden()).map(PostActionDisplay::getOutputItems).flatMap(Collection::stream).map(EmiStack::of).forEach(this.outputs::add);
        recipe.getBlockOutputs().stream().map(BlockPredicateExtensions::matchedFluids).flatMap(Collection::stream).distinct().map(EmiStack::of).forEach(this.outputs::add);
    }

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    public ResourceLocation getId() {
        return this.recipe.id();
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiIngredient> getCatalysts() {
        return this.catalysts;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return this.category.instance().width();
    }

    public int getDisplayHeight() {
        return this.category.instance().height();
    }

    public void addWidgets(final WidgetHolder widgets) {
        RvCategoryInstance<R> instance = this.category.instance();
        RvCategoryLayoutBuilder.Wrapped layoutBuilder = new RvCategoryLayoutBuilder.Wrapped<R>(instance, this.recipe){

            @Override
            protected void _actionGroup(R recipe, Vector2fc position) {
                EmiRecipeAdapter.this.actionGroup(widgets, recipe, position.x(), position.y());
            }

            @Override
            protected void _ingredientGroup(R recipe, Vector2fc position) {
                EmiRecipeAdapter.this.ingredientGroup(widgets, recipe, position.x(), position.y());
            }
        };
        instance.type().configureLayout(layoutBuilder, this.recipe);
        RvCategoryWidgetBuilder widgetBuilder = new RvCategoryWidgetBuilder<R>(this, instance, this.recipe){

            @Override
            public void addElement(RenderElement element) {
                ScreenElement unwrapped;
                boolean interactive = false;
                if (element instanceof InteractiveRenderElement) {
                    InteractiveRenderElement interactiveElement = (InteractiveRenderElement)element;
                    boolean bl = interactive = interactiveElement.getTooltip() != null || interactiveElement.getOnInput() != null;
                }
                if (!interactive && (unwrapped = WrapperRenderElement.unwrap(element)) instanceof TextElementRenderer) {
                    TextElementRenderer text = (TextElementRenderer)unwrapped;
                    int x = (int)element.x();
                    if (text.centered) {
                        x -= Minecraft.getInstance().font.width((FormattedText)text.text) / 2;
                    }
                    widgets.addText(text.text, x, (int)element.y(), text.lightModeColor, text.shadow);
                    return;
                }
                widgets.add((Widget)new EmiWidgetAdapter(element));
            }
        };
        instance.configureDecorations(widgetBuilder, this.recipe);
    }

    private void ingredientGroup(WidgetHolder widgets, R recipe, float x, float y) {
        EmiRecipeAdapter.slotGroup(widgets, x, y, this.ingredients, (w, pair, x0, y0) -> {
            IngredientInfo info = (IngredientInfo)pair.getFirst();
            LycheeSlotWidget widget = (LycheeSlotWidget)w.add((Widget)new LycheeSlotWidget((EmiIngredient)pair.getSecond(), (int)x0, (int)y0, info.type));
            if (!(info.relatedAction instanceof DamageItem)) {
                for (Component tooltip : info.tooltips) {
                    widget.appendTooltip(tooltip);
                }
            }
        });
    }

    private void actionGroup(WidgetHolder widgets, R recipe, float x, float y) {
        EmiRecipeAdapter.slotGroup(widgets, x, y, recipe.postActions().stream().filter(it -> !it.hidden()).toList(), this::actionSlot);
    }

    static <T> void slotGroup(WidgetHolder widgets, float x, float y, List<T> items, SlotLayoutFunction<T> layoutFunction) {
        int size = Math.min(items.size(), 9);
        int gridX = (int)Math.ceil(Math.sqrt(size));
        int gridY = (int)Math.ceil((float)size / (float)gridX);
        x -= (float)(gridX * 9);
        y -= (float)(gridY * 9);
        int index = 0;
        for (int i = 0; i < gridY; ++i) {
            for (int j = 0; j < gridX && index < size; ++index, ++j) {
                layoutFunction.apply(widgets, items.get(index), (int)(x + (float)(j * 19)), (int)(y + (float)(i * 19)));
            }
        }
    }

    private void actionSlot(WidgetHolder widgets, PostAction action, float x, float y) {
        ArrayList entries = Lists.newArrayList();
        HashMap itemMap = Maps.newHashMap();
        this.buildActionSlot(entries, action, itemMap);
        SlotType slotType = action.conditions().showingCount() == 0 ? SlotType.NORMAL : SlotType.CHANCE;
        LycheeSlotWidget widget = (LycheeSlotWidget)widgets.add((Widget)new LycheeSlotWidget(EmiIngredient.of((List)entries), (int)x, (int)y, slotType));
        widget.recipeContext(this);
    }

    private void buildActionSlot(List<EmiIngredient> entries, final PostAction action, Map<EmiIngredient, PostAction> itemMap) {
        PostAction postAction = action;
        Objects.requireNonNull(postAction);
        PostAction postAction2 = postAction;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DropItem.class, CompoundAction.class}, (Object)postAction2, n)) {
            case 0: {
                DropItem dropItem = (DropItem)postAction2;
                final ActionRenderer renderer = ActionRenderer.of(action);
                ItemEmiStack entry = new ItemEmiStack(this, dropItem.itemStack()){

                    public void render(GuiGraphics draw, int x, int y, float delta, int flags) {
                        if (action.commonProperties().icon() == null) {
                            super.render(draw, x, y, delta, flags);
                        } else {
                            renderer.internalRender(action, draw, x, y);
                        }
                    }

                    public List<ClientTooltipComponent> getTooltip() {
                        List tooltip = super.getTooltip();
                        ArrayList list = Lists.newArrayList();
                        ActionRenderer.appendConditionTooltips(list, action, (Player)Minecraft.getInstance().player);
                        if (!list.isEmpty()) {
                            list.stream().map(Component::getVisualOrderText).map(ClientTooltipComponent::create).forEach(tooltip::add);
                        }
                        return tooltip;
                    }
                };
                if (action.commonProperties().icon() != null) {
                    entry.setUnbatchable();
                }
                entries.add((EmiIngredient)entry);
                itemMap.put((EmiIngredient)entry, dropItem);
                break;
            }
            case 1: {
                CompoundAction compoundAction = (CompoundAction)((Object)postAction2);
                compoundAction.getChildActions().filter(it -> !it.hidden()).forEach(child -> this.buildActionSlot(entries, (PostAction)child, itemMap));
                break;
            }
            default: {
                entries.add((EmiIngredient)new PostActionEmiStack(action));
            }
        }
    }

    public boolean hideCraftable() {
        return true;
    }

    @FunctionalInterface
    static interface SlotLayoutFunction<T> {
        public void apply(WidgetHolder var1, T var2, float var3, float var4);
    }
}

