/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.context;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.context.LootParamsContext;

@FunctionalInterface
public interface LootParamInit {
    public static final Map<LootContextParam<?>, LootParamInit> LOOKUP = Maps.newLinkedHashMap();
    public static final LootParamInit ORIGIN = LootParamInit.register(LootContextParams.ORIGIN, (level, params) -> {
        if (!params.has(LycheeLootContextParams.BLOCK_POS)) {
            return null;
        }
        return Vec3.atCenterOf((Vec3i)((Vec3i)params.get(LycheeLootContextParams.BLOCK_POS)));
    });
    public static final LootParamInit BLOCK_POS = LootParamInit.register(LycheeLootContextParams.BLOCK_POS, (level, params) -> {
        if (!params.has(LootContextParams.ORIGIN)) {
            return null;
        }
        return BlockPos.containing((Position)((Position)params.get(LootContextParams.ORIGIN)));
    });
    public static final LootParamInit BLOCK_STATE = LootParamInit.register(LootContextParams.BLOCK_STATE, (level, params) -> {
        BlockPos pos = params.getOrNull(LycheeLootContextParams.BLOCK_POS);
        if (pos == null) {
            return null;
        }
        return level.getBlockState(pos);
    });
    public static final LootParamInit BLOCK_ENTITY = LootParamInit.register(LootContextParams.BLOCK_ENTITY, (level, params) -> {
        BlockPos pos = params.getOrNull(LycheeLootContextParams.BLOCK_POS);
        if (pos == null) {
            return null;
        }
        return level.getBlockEntity(pos);
    });

    public static LootParamInit register(LootContextParam<?> param, LootParamInit init) {
        LOOKUP.put(param, init);
        return init;
    }

    @Nullable
    public Object init(Level var1, LootParamsContext var2);
}

