/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.contextual;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.util.BoundsExtensions;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.contextual.ContextualCondition;
import snownee.lychee.util.contextual.ContextualConditionType;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record EntityHealth(MinMaxBounds.Doubles range) implements ContextualCondition
{
    public ContextualConditionType<EntityHealth> type() {
        return ContextualConditionType.ENTITY_HEALTH;
    }

    @Override
    public int test(@Nullable ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        Entity entity = (Entity)ctx.get(LycheeContextKey.LOOT_PARAMS).get(LootContextParams.THIS_ENTITY);
        double health = 0.0;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            health = living.getHealth();
        }
        return this.range.matches(health) ? times : 0;
    }

    @Override
    public MutableComponent getDescription(boolean inverted) {
        return Component.translatable((String)this.getDescriptionId(inverted), (Object[])new Object[]{BoundsExtensions.getDescription(this.range)});
    }

    public static class Type
    implements ContextualConditionType<EntityHealth> {
        public static final MapCodec<EntityHealth> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MinMaxBounds.Doubles.CODEC.fieldOf("range").forGetter(EntityHealth::range)).apply((Applicative)instance, EntityHealth::new));

        @Override
        public MapCodec<EntityHealth> codec() {
            return CODEC;
        }
    }
}

