/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.context.ItemShapelessContext;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.recipes.ItemInsideRecipe;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.LycheeCounter;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.recipe.ItemShapelessRecipeType;
import snownee.lychee.util.recipe.LycheeRecipeType;

public class ItemInsideRecipeType
extends LycheeRecipeType<ItemInsideRecipe> {
    private final List<RecipeHolder<ItemInsideRecipe>> specialRecipes = Lists.newArrayList();
    private final Multimap<Item, RecipeHolder<ItemInsideRecipe>> recipesByItem = ArrayListMultimap.create();

    public ItemInsideRecipeType(String name, Class<ItemInsideRecipe> clazz, @Nullable LootContextParamSet contextParamSet) {
        super(name, clazz, contextParamSet);
    }

    @Override
    @MustBeInvokedByOverriders
    public void refreshCache() {
        this.specialRecipes.clear();
        this.recipesByItem.clear();
        super.refreshCache();
        Object2FloatOpenHashMap itemWeights = new Object2FloatOpenHashMap();
        List caches = this.recipes.stream().filter(it -> {
            if (((ItemInsideRecipe)it.value()).getIngredients().stream().noneMatch(CommonProxy::isSimpleIngredient)) {
                this.specialRecipes.add((RecipeHolder<ItemInsideRecipe>)it);
                return false;
            }
            return true;
        }).map(recipeHolder -> new Cache((RecipeHolder<ItemInsideRecipe>)recipeHolder, ((ItemInsideRecipe)recipeHolder.value()).sizedIngredients().stream().map(ingredient -> {
            List<Item> items = Arrays.stream(ingredient.getItems()).map(ItemStack::getItem).toList();
            float weight = (float)ingredient.count() / (float)items.size();
            for (Item item : items) {
                itemWeights.merge((Object)item, weight, Float::sum);
            }
            return Sets.newHashSet(items);
        }).toList())).collect(Collectors.toList());
        List<Item> weightedItems = itemWeights.object2FloatEntrySet().stream().sorted((a, b) -> Float.compare(b.getFloatValue(), a.getFloatValue())).map(Map.Entry::getKey).toList();
        for (Item item : weightedItems) {
            caches.removeIf(cache -> {
                if (cache.ingredients().stream().anyMatch(it -> it.contains(item))) {
                    this.recipesByItem.put((Object)item, cache.recipe());
                    return cache.ingredients().stream().peek(it -> it.remove(item)).anyMatch(Set::isEmpty);
                }
                return false;
            });
        }
    }

    @Override
    public Comparator<RecipeHolder<ItemInsideRecipe>> comparator() {
        return Comparator.comparing(RecipeHolder::value, Comparator.comparingInt($ -> $.getIngredients().size()).thenComparingInt($ -> -$.time()).thenComparing($ -> !$.maxRepeats().isAny()).thenComparing(Recipe::isSpecial).reversed());
    }

    public void process(Entity entity, ItemStack stack, BlockPos pos, Vec3 origin) {
        ResourceLocation prevRecipeId;
        if (this.isEmpty()) {
            return;
        }
        if (entity instanceof LycheeCounter) {
            LycheeCounter counter = (LycheeCounter)entity;
            prevRecipeId = counter.lychee$getRecipeId();
            counter.lychee$setRecipeId(null);
        } else {
            prevRecipeId = null;
        }
        Collection recipes = this.recipesByItem.get((Object)stack.getItem());
        if (recipes.isEmpty() && this.specialRecipes.isEmpty()) {
            return;
        }
        Level level = entity.level();
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        List itemEntities = level.getEntitiesOfClass(ItemEntity.class, AABB.ofSize((Vec3)origin, (double)3.0, (double)3.0, (double)3.0), it -> {
            if (it.isRemoved()) {
                return false;
            }
            return pos.equals((Object)it.blockPosition()) || level.getBlockState(it.blockPosition()).is(block);
        });
        LycheeContext context = new LycheeContext();
        context.put(LycheeContextKey.LEVEL, level);
        ItemShapelessContext itemShapelessContext = new ItemShapelessContext(itemEntities, context);
        context.put(LycheeContextKey.ITEM_SHAPELESS, itemShapelessContext);
        LootParamsContext lootParams = context.initLootParams(this);
        lootParams.set(LootContextParams.ORIGIN, CommonProxy.clampPos(origin, pos));
        lootParams.set(LootContextParams.THIS_ENTITY, entity);
        lootParams.set(LootContextParams.BLOCK_STATE, blockState);
        lootParams.set(LycheeLootContextParams.BLOCK_POS, pos);
        lootParams.validate();
        RecipeHolder prevRecipe = Optional.ofNullable(prevRecipeId).map(CommonProxy::recipe).filter(it -> it.value() instanceof ItemInsideRecipe).orElse(null);
        Iterable allRecipes = Iterables.concat((Iterable)recipes, this.specialRecipes);
        if (prevRecipe != null) {
            allRecipes = Iterables.concat(List.of(prevRecipe), (Iterable)Iterables.filter((Iterable)allRecipes, it -> !it.equals((Object)prevRecipe)));
        }
        ItemShapelessRecipeType.process(this, allRecipes, context, it -> {
            ((LycheeCounter)entity).lychee$update(prevRecipeId, it);
            return ((ItemInsideRecipe)it.value()).tickOrApply(context);
        });
    }

    public record Cache(RecipeHolder<ItemInsideRecipe> recipe, List<? extends Set<Item>> ingredients) {
    }
}

