/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.codec;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import com.mojang.serialization.MapLike;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.contextual.Chance;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.action.PostActionType;
import snownee.lychee.util.codec.ActionParsers;

public interface LycheeParser<T> {
    public static final Map<String, LycheeParser<? extends PostAction>> ACTION_PARSERS = (Map)Util.make((Object)Maps.newHashMap(), map -> {
        map.put("drop", new ActionParsers.Drop());
        map.put("place", new ActionParsers.Place());
        ActionParsers.Run run = new ActionParsers.Run();
        map.put("run", run);
        map.put("execute", run);
        map.put("delay", new ActionParsers.DelayParser());
        map.put("set_block", new ActionParsers.SetBlockParser());
        map.put("move", new ActionParsers.MoveParser());
        map.put("add_item_cooldown", new ActionParsers.ItemCooldown());
    });

    public static DataResult<PostAction> action(String s) {
        try {
            return LycheeParser.action(new StringReader(s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse action %s: %s".formatted(s, e.getMessage()));
        }
    }

    public static DataResult<PostAction> action(StringReader reader) throws Exception {
        ResourceLocation id = ResourceLocation.read((StringReader)reader);
        LycheeParser<? extends PostAction> parser = ACTION_PARSERS.get(id.getNamespace().equals("minecraft") ? id.getPath() : id.toString());
        DataResult result = null;
        if (parser != null) {
            result = parser.parse(reader);
        }
        if (result == null || result.isError()) {
            PostActionType actionType = (PostActionType)LycheeRegistries.POST_ACTION.get(id);
            if (actionType == null && parser != null) {
                return result;
            }
            if (actionType == null) {
                return DataResult.error(() -> "Unknown action type or parser: " + String.valueOf(id));
            }
            DataResult secondResult = actionType.codec().decode((DynamicOps)JavaOps.INSTANCE, (MapLike)EmptyMapLike.INSTANCE);
            if (secondResult.isError()) {
                if (result != null) {
                    String firstError = ((DataResult.Error)result.error().orElseThrow()).message();
                    String secondError = ((DataResult.Error)secondResult.error().orElseThrow()).message();
                    return DataResult.error(() -> "Failed to parse action %s: <First: %s; Second: %s>".formatted(id, firstError, secondError));
                }
                return secondResult.mapError(err -> "Failed to parse action of type " + String.valueOf(id) + ": " + err);
            }
            result = secondResult;
        }
        if (!reader.canRead()) {
            return result;
        }
        reader.expect(' ');
        PostAction action = (PostAction)result.getOrThrow();
        PostActionCommonProperties.Builder properties = action.commonProperties().builder();
        boolean chance = false;
        while (reader.canRead()) {
            reader.expect('/');
            String word = reader.readUnquotedString().toLowerCase();
            if (word.equals("hide")) {
                properties.hide();
                continue;
            }
            try {
                float f = Float.parseFloat(word);
                Preconditions.checkArgument((f > 0.0f && f < 1.0f ? 1 : 0) != 0, (Object)"Chance must be between 0 and 1");
                Preconditions.checkState((!chance ? 1 : 0) != 0, (Object)"Chance already set");
                chance = true;
                properties.conditions().add(new Chance(f));
            }
            catch (NumberFormatException e) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext((ImmutableStringReader)reader);
            }
        }
        return DataResult.success((Object)LycheeParser.replaceProperties(action, properties.build()));
    }

    private static PostAction replaceProperties(PostAction action, PostActionCommonProperties properties) throws Exception {
        Class<?> clazz = action.getClass();
        Preconditions.checkArgument((boolean)clazz.isRecord(), (String)"Not a record: %s", (Object)action);
        RecordComponent[] components = clazz.getRecordComponents();
        Object[] args = new Object[components.length];
        for (int i = 0; i < components.length; ++i) {
            args[i] = i == 0 ? properties : components[i].getAccessor().invoke((Object)action, new Object[0]);
        }
        Class[] paramTypes = (Class[])Arrays.stream(components).map(RecordComponent::getType).toArray(Class[]::new);
        return (PostAction)clazz.getDeclaredConstructor(paramTypes).newInstance(args);
    }

    public DataResult<T> parse(StringReader var1) throws CommandSyntaxException;

    public static enum EmptyMapLike implements MapLike<Object>
    {
        INSTANCE;


        @Nullable
        public Object get(Object key) {
            return null;
        }

        @Nullable
        public Object get(String key) {
            return null;
        }

        public Stream<Pair<Object, Object>> entries() {
            return Stream.empty();
        }

        public String toString() {
            return "EmptyMapLike";
        }
    }
}

