/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.contextual;

import com.mojang.serialization.Codec;
import net.minecraft.core.Registry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.contextual.And;
import snownee.lychee.contextual.Chance;
import snownee.lychee.contextual.CustomCondition;
import snownee.lychee.contextual.DirectionCheck;
import snownee.lychee.contextual.EntityHealth;
import snownee.lychee.contextual.Execute;
import snownee.lychee.contextual.FallDistance;
import snownee.lychee.contextual.IsDifficulty;
import snownee.lychee.contextual.IsOffItemCooldown;
import snownee.lychee.contextual.IsSneaking;
import snownee.lychee.contextual.IsWeather;
import snownee.lychee.contextual.Location;
import snownee.lychee.contextual.Not;
import snownee.lychee.contextual.Or;
import snownee.lychee.contextual.Param;
import snownee.lychee.contextual.SkyDarken;
import snownee.lychee.contextual.Time;
import snownee.lychee.util.SerializableType;
import snownee.lychee.util.contextual.ContextualCondition;

public interface ContextualConditionType<T extends ContextualCondition>
extends SerializableType<T> {
    public static final ContextualConditionType<And> AND = ContextualConditionType.register("and", new And.Type());
    public static final ContextualConditionType<Or> OR = ContextualConditionType.register("or", new Or.Type());
    public static final ContextualConditionType<Not> NOT = ContextualConditionType.register("not", new Not.Type());
    public static final ContextualConditionType<Chance> CHANCE = ContextualConditionType.register("chance", new Chance.Type());
    public static final ContextualConditionType<Location> LOCATION = ContextualConditionType.register("location", new Location.Type());
    public static final ContextualConditionType<IsDifficulty> DIFFICULTY = ContextualConditionType.register("difficulty", new IsDifficulty.Type());
    public static final ContextualConditionType<IsWeather> WEATHER = ContextualConditionType.register("weather", new IsWeather.Type());
    public static final ContextualConditionType<Time> TIME = ContextualConditionType.register("time", new Time.Type());
    public static final ContextualConditionType<Execute> EXECUTE = ContextualConditionType.register("execute", new Execute.Type());
    public static final ContextualConditionType<FallDistance> FALL_DISTANCE = ContextualConditionType.register("fall_distance", new FallDistance.Type());
    public static final ContextualConditionType<EntityHealth> ENTITY_HEALTH = ContextualConditionType.register("entity_health", new EntityHealth.Type());
    public static final ContextualConditionType<IsSneaking> IS_SNEAKING = ContextualConditionType.register("is_sneaking", new IsSneaking.Type());
    public static final ContextualConditionType<DirectionCheck> DIRECTION = ContextualConditionType.register("direction", new DirectionCheck.Type());
    public static final ContextualConditionType<Param> PARAM = ContextualConditionType.register("param", new Param.Type());
    public static final ContextualConditionType<IsOffItemCooldown> IS_OFF_ITEM_COOLDOWN = ContextualConditionType.register("is_off_item_cooldown", new IsOffItemCooldown.Type());
    public static final ContextualConditionType<SkyDarken> SKY_DARKEN = ContextualConditionType.register("sky_darken", new SkyDarken.Type());
    public static final ContextualConditionType<CustomCondition> CUSTOM = ContextualConditionType.register("custom", new CustomCondition.Type());

    public static <T extends ContextualConditionType<?>> T register(String name, T object) {
        return ContextualConditionType.register(ResourceLocation.parse((String)name), object);
    }

    public static <T extends ContextualConditionType<?>> T register(ResourceLocation location, T object) {
        Registry.register(LycheeRegistries.CONTEXTUAL, (ResourceLocation)location, object);
        return object;
    }

    @Override
    default public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
        return ByteBufCodecs.fromCodecWithRegistries((Codec)this.codec().codec());
    }
}

