/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.recipe;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.util.KUtil;
import snownee.lychee.Lychee;
import snownee.lychee.mixin.LootContextParamSetsAccess;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.recipe.ILycheeRecipe;

public class LycheeRecipeType<T extends ILycheeRecipe<LycheeContext>>
implements RecipeType<T> {
    public final ResourceLocation id;
    public ResourceLocation categoryId;
    public final Class<? extends T> clazz;
    public final LootContextParamSet contextParamSet;
    protected List<RecipeHolder<T>> recipes;
    public boolean requiresClient;
    public boolean canPreventConsumeInputs;
    private boolean empty = true;
    public static final Component DEFAULT_PREVENT_TIP = Component.translatable((String)"tip.lychee.preventDefault.default").withStyle(ChatFormatting.YELLOW);

    public LycheeRecipeType(String name, Class<T> clazz, @Nullable LootContextParamSet contextParamSet) {
        this.id = this.categoryId = Lychee.id(name);
        this.clazz = clazz;
        this.contextParamSet = contextParamSet == null ? (LootContextParamSet)LootContextParamSetsAccess.registry().get((Object)this.id) : contextParamSet;
        Objects.requireNonNull(this.contextParamSet);
    }

    public String toString() {
        return "LycheeRecipeType[" + String.valueOf(this.id) + "]";
    }

    public Optional<RecipeHolder<T>> tryMatch(RecipeHolder<T> recipeHolder, Level level, LycheeContext context) {
        ILycheeRecipe recipe = (ILycheeRecipe)recipeHolder.value();
        return recipe.matches(context, level) && recipe.test(recipe, context, 1) > 0 ? Optional.of(recipeHolder) : Optional.empty();
    }

    public List<RecipeHolder<T>> recipes() {
        return this.recipes;
    }

    public List<RecipeHolder<T>> inViewerRecipes() {
        return KUtil.getRecipes((RecipeType)this).stream().filter(it -> !((ILycheeRecipe)it.value()).hideInRecipeViewer()).toList();
    }

    public void updateEmptyState() {
        this.empty = this.recipes.isEmpty();
    }

    public boolean isEmpty() {
        return this.empty;
    }

    @MustBeInvokedByOverriders
    public void refreshCache() {
        this.recipes = KUtil.getRecipes((RecipeType)this).stream().filter(it -> !((ILycheeRecipe)it.value()).ghost()).sorted(this.comparator()).toList();
    }

    public Comparator<RecipeHolder<T>> comparator() {
        return Comparator.comparing(RecipeHolder::value, Comparator.comparing(Recipe::isSpecial));
    }

    public Optional<RecipeHolder<T>> findFirst(LycheeContext context, Level level) {
        return this.recipes.stream().flatMap(it -> this.tryMatch((RecipeHolder<T>)it, level, context).stream()).findFirst();
    }

    public Component getPreventDefaultDescription(T recipe) {
        return DEFAULT_PREVENT_TIP;
    }
}

