/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.ui;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.Registry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.ui.BlockElement;
import snownee.lychee.ui.ItemElement;
import snownee.lychee.ui.SpriteElement;
import snownee.lychee.ui.TextElement;
import snownee.lychee.util.SerializableType;
import snownee.lychee.util.ui.UIElement;

public interface UIElementType<T extends UIElement>
extends SerializableType<T> {
    public static final UIElementType<SpriteElement> SPRITE = UIElementType.register("sprite", SpriteElement.CODEC, SpriteElement.STREAM_CODEC);
    public static final UIElementType<ItemElement> ITEM = UIElementType.register("item", ItemElement.CODEC, ItemElement.STREAM_CODEC);
    public static final UIElementType<BlockElement> BLOCK = UIElementType.register("block", BlockElement.CODEC, BlockElement.STREAM_CODEC);
    public static final UIElementType<TextElement> TEXT = UIElementType.register("text", TextElement.CODEC, TextElement.STREAM_CODEC);

    public static <T extends UIElement> UIElementType<T> register(String name, MapCodec<T> codec) {
        return UIElementType.register(name, () -> codec);
    }

    public static <T extends UIElement> UIElementType<T> register(String name, final MapCodec<T> codec, final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec) {
        return UIElementType.register(name, new UIElementType<T>(){

            @Override
            public MapCodec<T> codec() {
                return codec;
            }

            @Override
            public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
                return streamCodec;
            }
        });
    }

    public static <T extends UIElement> UIElementType<T> register(String name, UIElementType<T> type) {
        return (UIElementType)Registry.register(LycheeRegistries.UI_ELEMENT, (ResourceLocation)ResourceLocation.parse((String)name), type);
    }

    @Override
    default public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
        return ByteBufCodecs.fromCodecWithRegistries((Codec)this.codec().codec());
    }
}

