/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.datamaps.chemical.attribute;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.attribute.ChemicalAttributes;
import mekanism.api.datamaps.chemical.attribute.IChemicalCoolant;
import mekanism.api.text.APILang;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ITooltipHelper;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.ApiStatus;

public record HeatedCoolant(Holder<Chemical> otherVariant, double thermalEnthalpy, double conductivity, double temperature) implements IChemicalCoolant
{
    private static final double BASE_COOLING_EFFICIENCY = 0.4;
    private static final double BASE_COOLANT_TEMP = 100000.0;
    private static final double MAX_COOLANT_TEMP = 1000000.0;
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"chemical_attribute_heated_coolant");
    public static final Codec<HeatedCoolant> CODEC = RecordCodecBuilder.create(instance -> IChemicalCoolant.createBaseCodec(instance, "cool_variant", 0.4).and((App)Codec.doubleRange((double)Double.MIN_VALUE, (double)1000000.0).optionalFieldOf("temperature", (Object)100000.0).forGetter(HeatedCoolant::temperature)).apply((Applicative)instance, HeatedCoolant::new));

    public HeatedCoolant(Holder<Chemical> otherVariant, double thermalEnthalpy) {
        this(otherVariant, thermalEnthalpy, 0.4, 100000.0);
    }

    public HeatedCoolant {
        IChemicalCoolant.validateCoolantParams(otherVariant, thermalEnthalpy, conductivity);
        if (temperature <= 0.0 || temperature > 1000000.0) {
            throw new IllegalArgumentException("Coolant attributes must have a temperature greater than zero and at most 1000000.0! Temperature: " + temperature);
        }
    }

    public ChemicalStack cool(long amountCooled) {
        return new ChemicalStack(this.otherVariant, amountCooled);
    }

    @Override
    public void collectTooltips(Item.TooltipContext context, List<Component> tooltips, TooltipFlag tooltipFlag) {
        IChemicalCoolant.super.collectTooltips(context, tooltips, tooltipFlag);
        tooltips.add((Component)APILang.CHEMICAL_ATTRIBUTE_COOLANT_TEMPERATURE.translateColored(EnumColor.GRAY, EnumColor.INDIGO, ITooltipHelper.INSTANCE.getTemperatureDisplayShort(this.temperature)));
    }

    @Override
    @ApiStatus.Internal
    public ChemicalAttributes.HeatedCoolant toLegacyAttribute() {
        return new ChemicalAttributes.HeatedCoolant(this);
    }
}

