/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.jei.machine;

import java.util.List;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.NucleosynthesizingRecipe;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiDynamicHorizontalRateBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiChemicalGauge;
import mekanism.client.gui.element.gauge.GuiEnergyGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.recipe_viewer.jei.HolderRecipeCategory;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.lib.Color;
import mekanism.common.tile.component.config.DataType;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public class NucleosynthesizingRecipeCategory
extends HolderRecipeCategory<NucleosynthesizingRecipe> {
    private final GuiDynamicHorizontalRateBar rateBar;
    private final GuiSlot input = this.addSlot(SlotType.INPUT, 26, 40);
    private final GuiSlot extra = this.addSlot(SlotType.EXTRA, 6, 69);
    private final GuiSlot output = this.addSlot(SlotType.OUTPUT, 152, 40);
    private final GuiGauge<?> chemicalInput;

    public NucleosynthesizingRecipeCategory(IGuiHelper helper, IRecipeViewerRecipeType<NucleosynthesizingRecipe> recipeType) {
        super(helper, recipeType);
        this.addSlot(SlotType.POWER, 173, 69).with(SlotOverlay.POWER);
        this.addElement(new GuiInnerScreen(this, 45, 18, 104, 68));
        GaugeType type = GaugeType.SMALL_MED.with(DataType.INPUT);
        this.chemicalInput = this.addElement(GuiChemicalGauge.getDummy(type, this, 5, 18));
        this.addElement(new GuiEnergyGauge(new GuiEnergyGauge.IEnergyInfoHandler(this){

            @Override
            public long getEnergy() {
                return 1L;
            }

            @Override
            public long getMaxEnergy() {
                return 1L;
            }
        }, GaugeType.SMALL_MED, (IGuiWrapper)this, 172, 18));
        this.rateBar = this.addElement(new GuiDynamicHorizontalRateBar((IGuiWrapper)this, this.getBarProgressTimer(), 5, 88, 183, Color.ColorFunction.scale(Color.rgbi(60, 45, 74), Color.rgbi(100, 30, 170))));
    }

    public void getTooltip(ITooltipBuilder tooltip, RecipeHolder<NucleosynthesizingRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (this.rateBar.isMouseOver(mouseX, mouseY)) {
            tooltip.add((FormattedText)MekanismLang.TICKS_REQUIRED.translate(((NucleosynthesizingRecipe)recipeHolder.value()).getDuration()));
        }
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, RecipeHolder<NucleosynthesizingRecipe> recipeHolder, @NotNull IFocusGroup focusGroup) {
        NucleosynthesizingRecipe recipe = (NucleosynthesizingRecipe)recipeHolder.value();
        this.initItem(builder, RecipeIngredientRole.INPUT, this.input, recipe.getItemInput().getRepresentations());
        List<ChemicalStack> scaledChemicals = recipe.getChemicalInput().getRepresentations();
        if (recipe.perTickUsage()) {
            scaledChemicals = scaledChemicals.stream().map(chemical -> chemical.copyWithAmount(chemical.getAmount() * 400L)).toList();
        }
        this.initChemical(builder, RecipeIngredientRole.INPUT, this.chemicalInput, scaledChemicals);
        this.initItem(builder, RecipeIngredientRole.OUTPUT, this.output, recipe.getOutputDefinition());
        this.initItem(builder, RecipeIngredientRole.CATALYST, this.extra, RecipeViewerUtils.getStacksFor(recipe.getChemicalInput(), true));
    }
}

