/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.hud;

import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.MathUtils;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MekaSuitEnergyLevel
implements LayeredDraw.Layer {
    public static final MekaSuitEnergyLevel INSTANCE = new MekaSuitEnergyLevel();
    private static final ResourceLocation POWER_BAR = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BAR, "horizontal_power_long.png");

    private MekaSuitEnergyLevel() {
    }

    public void render(@NotNull GuiGraphics graphics, @NotNull DeltaTracker delta) {
        Minecraft minecraft = Minecraft.getInstance();
        if (!minecraft.gameMode.canHurtPlayer() || minecraft.options.hideGui || !MekanismConfig.client.hudRenderMekaSuitEnergyBar.get()) {
            return;
        }
        long capacity = 0L;
        long stored = 0L;
        for (ItemStack stack : minecraft.player.getArmorSlots()) {
            IEnergyContainer container;
            if (!(stack.getItem() instanceof ItemMekaSuitArmor) || (container = StorageUtils.getEnergyContainer(stack, 0)) == null) continue;
            capacity = MathUtils.addClamped(capacity, container.getMaxEnergy());
            stored = MathUtils.addClamped(stored, container.getEnergy());
        }
        if (capacity != 0L) {
            int x = graphics.guiWidth() / 2 - 91;
            int y = graphics.guiHeight() - minecraft.gui.leftHeight + 2;
            int length = (int)Math.round((double)stored / (double)capacity * 79.0);
            GuiUtils.renderExtendedTexture(graphics, GuiBar.BAR, 2, 2, x, y, 81, 6);
            graphics.blit(POWER_BAR, x + 1, y + 1, length, 4, 0.0f, 0.0f, length, 4, 79, 4);
            minecraft.gui.leftHeight += 8;
        }
    }
}

