/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.lib;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import mekanism.common.lib.Color;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Vertex {
    private final Map<VertexFormatElement, int[]> miscData;
    private Vector3f pos;
    private Vector3f normal;
    private int red;
    private int green;
    private int blue;
    private int alpha;
    private float texU;
    private float texV;
    private int overlayU;
    private int overlayV;
    private int lightU;
    private int lightV;

    public Vertex() {
        this.miscData = new HashMap<VertexFormatElement, int[]>();
    }

    public Vertex(Vector3f pos, Vector3f normal, Color color, float texU, float texV, int overlayU, int overlayV, int lightU, int lightV) {
        this(pos, normal, color.r(), color.g(), color.b(), color.a(), texU, texV, overlayU, overlayV, lightU, lightV);
    }

    public Vertex(Vector3f pos, Vector3f normal, int red, int green, int blue, int alpha, float texU, float texV, int overlayU, int overlayV, int lightU, int lightV) {
        this(pos, normal, red, green, blue, alpha, texU, texV, overlayU, overlayV, lightU, lightV, new HashMap<VertexFormatElement, int[]>());
    }

    public Vertex(Vector3f pos, Vector3f normal, int red, int green, int blue, int alpha, float texU, float texV, int overlayU, int overlayV, int lightU, int lightV, Map<VertexFormatElement, int[]> miscData) {
        this.pos = pos;
        this.normal = normal;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        this.texU = texU;
        this.texV = texV;
        this.overlayU = overlayU;
        this.overlayV = overlayV;
        this.lightU = lightU;
        this.lightV = lightV;
        this.miscData = miscData;
    }

    public static Vertex create(Vector3f pos, Vector3f normal, Color color, TextureAtlasSprite sprite, float texU, float texV, int overlayU, int overlayV, int lightU, int lightV) {
        return new Vertex(pos, normal, color, sprite.getU(texU), sprite.getV(texV), overlayU, overlayV, lightU, lightV);
    }

    public static Vertex create(Vector3f pos, Vector3f normal, Color color, TextureAtlasSprite sprite, float texU, float texV, int lightU, int lightV) {
        return Vertex.create(pos, normal, color, sprite, texU, texV, 0, 10, lightU, lightV);
    }

    public static Vertex create(Vector3f pos, Vector3f normal, Color color, TextureAtlasSprite sprite, float u, float v) {
        return Vertex.create(pos, normal, color, sprite, u, v, 0, 0);
    }

    public static Vertex create(Vector3f pos, Vector3f normal, TextureAtlasSprite sprite, float u, float v) {
        return Vertex.create(pos, normal, Color.WHITE, sprite, u, v);
    }

    public Vector3f getPos() {
        return this.pos;
    }

    public Vec3 getPosD() {
        return new Vec3(this.pos);
    }

    public Vector3f getNormal() {
        return this.normal;
    }

    public Vec3 getNormalD() {
        return new Vec3(this.getNormal());
    }

    public float getTexU() {
        return this.texU;
    }

    public float getTexV() {
        return this.texV;
    }

    public int getOverlayU() {
        return this.overlayU;
    }

    public int getOverlayV() {
        return this.overlayV;
    }

    public int getRawLightU() {
        return this.lightU;
    }

    public int getRawLightV() {
        return this.lightV;
    }

    public Vertex color(Color color) {
        return this.color(color.r(), color.g(), color.b(), color.a());
    }

    public Vertex color(int red, int green, int blue, int alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        return this;
    }

    public Vertex pos(Vector3f pos) {
        this.pos = pos;
        return this;
    }

    public Vertex pos(Vec3 pos) {
        return this.pos(pos.toVector3f());
    }

    public Vertex normal(float x, float y, float z) {
        return this.normal(new Vector3f(x, y, z));
    }

    public Vertex normal(Vector3f normal) {
        this.normal = normal;
        return this;
    }

    public Vertex normal(Vec3 normal) {
        return this.normal(normal.toVector3f());
    }

    public Vertex texRaw(float u, float v) {
        this.texU = u;
        this.texV = v;
        return this;
    }

    public Vertex overlay(int u, int v) {
        this.overlayU = u;
        this.overlayV = v;
        return this;
    }

    public Vertex lightRaw(int u, int v) {
        this.lightU = u;
        this.lightV = v;
        return this;
    }

    public Vertex light(int u, int v) {
        return this.lightRaw(u << 4, v << 4);
    }

    public Vertex misc(VertexFormatElement element, int ... data) {
        this.miscData.put(element, data);
        return this;
    }

    public Vertex flip() {
        return this.flip(true);
    }

    public Vertex flip(boolean deepCopy) {
        return this.copy(deepCopy).normal(-this.normal.x(), -this.normal.y(), -this.normal.z());
    }

    public Vertex copy(boolean deepCopy) {
        if (deepCopy) {
            HashMap<VertexFormatElement, int[]> miscCopy = new HashMap<VertexFormatElement, int[]>();
            for (Map.Entry<VertexFormatElement, int[]> entry : this.miscData.entrySet()) {
                miscCopy.put(entry.getKey(), Arrays.copyOf(entry.getValue(), entry.getValue().length));
            }
            return new Vertex(this.pos, new Vector3f((Vector3fc)this.normal), this.red, this.green, this.blue, this.alpha, this.texU, this.texV, this.overlayU, this.overlayV, this.lightU, this.lightV, miscCopy);
        }
        return new Vertex(this.pos, this.normal, this.red, this.green, this.blue, this.alpha, this.texU, this.texV, this.overlayU, this.overlayV, this.lightU, this.lightV, this.miscData);
    }

    public void write(VertexConsumer consumer) {
        consumer.addVertex(this.pos.x, this.pos.y, this.pos.z);
        consumer.setColor(this.red, this.green, this.blue, this.alpha);
        consumer.setUv(this.texU, this.texV);
        consumer.setUv1(this.overlayU, this.overlayV);
        consumer.setUv2(this.lightU, this.lightV);
        consumer.setNormal(this.normal.x(), this.normal.y(), this.normal.z());
        for (Map.Entry<VertexFormatElement, int[]> entry : this.miscData.entrySet()) {
            consumer.misc(entry.getKey(), entry.getValue());
        }
    }
}

