/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.energy.forgeenergy;

import mekanism.api.Action;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IEnergyConversion;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.common.util.UnitDisplayUtils;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@NothingNullByDefault
public class ForgeStrictEnergyHandler
implements IStrictEnergyHandler {
    private final IEnergyStorage storage;
    private final IEnergyConversion converter;

    public ForgeStrictEnergyHandler(IEnergyStorage storage) {
        this(storage, UnitDisplayUtils.EnergyUnit.FORGE_ENERGY);
    }

    @VisibleForTesting
    ForgeStrictEnergyHandler(IEnergyStorage storage, IEnergyConversion converter) {
        this.storage = storage;
        this.converter = converter;
    }

    @Override
    public int getEnergyContainerCount() {
        return 1;
    }

    @Override
    public long getEnergy(int container) {
        return container == 0 ? this.converter.convertFrom(this.storage.getEnergyStored()) : 0L;
    }

    @Override
    public void setEnergy(int container, long energy) {
    }

    @Override
    public long getMaxEnergy(int container) {
        return container == 0 ? this.converter.convertFrom(this.storage.getMaxEnergyStored()) : 0L;
    }

    @Override
    public long getNeededEnergy(int container) {
        return container == 0 ? this.converter.convertFrom(Math.max(0, this.storage.getMaxEnergyStored() - this.storage.getEnergyStored())) : 0L;
    }

    @Override
    public long insertEnergy(int container, long amount, @NotNull Action action) {
        return container == 0 ? this.insertEnergy(amount, action) : amount;
    }

    @Override
    public long insertEnergy(long amount, Action action) {
        if (this.storage.canReceive() && amount > 0L) {
            int inserted;
            int toInsert = this.converter.convertToAsInt(amount);
            if (toInsert == 0) {
                return amount;
            }
            if (!this.converter.isOneToOne()) {
                long simulatedInserted = this.storage.receiveEnergy(toInsert, true);
                if (simulatedInserted == 0L) {
                    return amount;
                }
                toInsert = this.convertFromAndBack(simulatedInserted);
                if ((long)toInsert == 0L) {
                    return amount;
                }
            }
            if ((inserted = this.storage.receiveEnergy(toInsert, action.simulate())) > 0) {
                return amount - this.converter.convertFrom(inserted);
            }
        }
        return amount;
    }

    private int convertFromAndBack(long fe) {
        long joules = this.converter.convertFrom(fe);
        int result = this.converter.convertToAsInt(joules);
        double conversion = 1.0 / this.converter.getConversion();
        if (conversion >= 1.0 && (double)result % conversion > 0.0) {
            return this.converter.convertToAsInt(joules - 1L);
        }
        return result;
    }

    @Override
    public long extractEnergy(int container, long amount, @NotNull Action action) {
        return container == 0 ? this.extractEnergy(amount, action) : 0L;
    }

    @Override
    public long extractEnergy(long amount, Action action) {
        if (this.storage.canExtract() && amount > 0L) {
            long simulatedExtracted;
            int toExtract = this.converter.convertToAsInt(amount);
            if (toExtract == 0) {
                return 0L;
            }
            if (!this.converter.isOneToOne() && (long)(toExtract = this.convertFromAndBack(simulatedExtracted = (long)this.storage.extractEnergy(toExtract, true))) == 0L) {
                return 0L;
            }
            int extracted = this.storage.extractEnergy(toExtract, action.simulate());
            return this.converter.convertFrom(extracted);
        }
        return 0L;
    }
}

