/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat.wthit;

import java.util.Iterator;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IDataReader;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.integration.lookingat.ILookingAtElement;
import mekanism.common.integration.lookingat.LookingAtElement;
import mekanism.common.integration.lookingat.TextElement;
import mekanism.common.integration.lookingat.wthit.MekanismWTHITPlugin;
import mekanism.common.integration.lookingat.wthit.WTHITLookingAtHelper;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class WTHITTooltipRenderer
implements IBlockComponentProvider,
IEntityComponentProvider {
    static final WTHITTooltipRenderer INSTANCE = new WTHITTooltipRenderer();

    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        this.append(tooltip, accessor.getData(), config);
    }

    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        this.append(tooltip, accessor.getData(), config);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void append(ITooltip tooltip, IDataReader dataReader, IPluginConfig config) {
        WTHITLookingAtHelper helper = (WTHITLookingAtHelper)dataReader.get(WTHITLookingAtHelper.TYPE);
        if (helper == null) return;
        tooltip.setLine(MekanismWTHITPlugin.MEK_DATA);
        Component lastText = null;
        Iterator iterator = helper.elements.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                if (lastText == null) return;
                tooltip.addLine(lastText);
                return;
            }
            ILookingAtElement element = (ILookingAtElement)iterator.next();
            if (element instanceof TextElement) {
                Component text;
                block6: {
                    TextElement textElement = (TextElement)element;
                    try {
                        Component component;
                        text = component = textElement.text();
                        if (lastText == null) break block6;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    tooltip.addLine(lastText);
                }
                lastText = text;
                continue;
            }
            if (config.getBoolean(element.getID())) {
                tooltip.addLine((ITooltipComponent)new MekElement(lastText, (LookingAtElement)element));
            }
            lastText = null;
        }
    }

    private record MekElement(@Nullable Component text, LookingAtElement element) implements ITooltipComponent
    {
        public int getWidth() {
            if (this.text == null) {
                return this.element.getWidth();
            }
            return Math.max(this.element.getWidth(), 96);
        }

        public int getHeight() {
            if (this.text == null) {
                return this.element.getHeight() + 2;
            }
            return this.element.getHeight() + 16;
        }

        public void render(GuiGraphics guiGraphics, int x, int y, DeltaTracker delta) {
            if (this.text != null) {
                this.element.drawScrollingString(guiGraphics, this.text, x, y + 3, IFancyFontRenderer.TextAlignment.LEFT, 0xFFFFFF, 4, false);
                y += 13;
            }
            this.element.render(guiGraphics, x, y + 1);
        }
    }
}

