/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.basic.BasicPressurizedReactionRecipe;
import mekanism.common.config.MekanismConfigTranslations;
import mekanism.common.integration.projecte.NSSChemical;
import mekanism.common.integration.projecte.mappers.TypedMekanismRecipeMapper;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.world.item.ItemStack;

@RecipeTypeMapper
public class PressurizedReactionRecipeMapper
extends TypedMekanismRecipeMapper<PressurizedReactionRecipe> {
    public PressurizedReactionRecipeMapper() {
        super(MekanismConfigTranslations.PE_MAPPER_PRESSURIZED_REACTION, PressurizedReactionRecipe.class, MekanismRecipeType.REACTION);
    }

    public boolean isAvailable() {
        return false;
    }

    @Override
    protected boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, PressurizedReactionRecipe recipe, TypedMekanismRecipeMapper.MekFakeGroupHelper fakeGroupHelper) {
        if (recipe instanceof BasicPressurizedReactionRecipe) {
            BasicPressurizedReactionRecipe basicRecipe = (BasicPressurizedReactionRecipe)recipe;
            ItemStack outputItem = basicRecipe.getOutputItem();
            ChemicalStack outputChemical = basicRecipe.getOutputChemical();
            if (outputItem.isEmpty() && outputChemical.isEmpty()) {
                return false;
            }
            return PressurizedReactionRecipeMapper.addConversions(mapper, new PressurizedReactionRecipe.PressurizedReactionRecipeOutput(outputItem, outputChemical), fakeGroupHelper.forIngredients(recipe.getInputSolid(), recipe.getInputFluid(), recipe.getInputChemical()));
        }
        return PressurizedReactionRecipeMapper.addConversions(mapper, recipe.getInputSolid(), recipe.getInputFluid(), recipe.getInputChemical(), recipe::getOutput, ConstantPredicates.alwaysFalse(), fakeGroupHelper::forItems, fakeGroupHelper::forFluids, fakeGroupHelper::forChemicals, null, PressurizedReactionRecipeMapper::addConversions);
    }

    private static boolean addConversions(IMappingCollector<NormalizedSimpleStack, Long> mapper, PressurizedReactionRecipe.PressurizedReactionRecipeOutput output, Object2IntMap<NormalizedSimpleStack> inputs) {
        if (inputs.isEmpty()) {
            return false;
        }
        ItemStack outputItem = output.item();
        ChemicalStack outputChemical = output.chemical();
        if (outputItem.isEmpty()) {
            return PressurizedReactionRecipeMapper.addConversion(mapper, outputChemical, inputs);
        }
        if (outputChemical.isEmpty()) {
            return PressurizedReactionRecipeMapper.addConversion(mapper, outputItem, inputs);
        }
        if (outputChemical.getAmount() > Integer.MAX_VALUE) {
            return false;
        }
        return PressurizedReactionRecipeMapper.addConversion(mapper, outputItem, PressurizedReactionRecipeMapper.forIngredients(inputs, (NormalizedSimpleStack)NSSChemical.createChemical(outputChemical), (int)(-outputChemical.getAmount()))) | PressurizedReactionRecipeMapper.addConversion(mapper, outputChemical, PressurizedReactionRecipeMapper.forIngredients(inputs, (NormalizedSimpleStack)NSSItem.createItem((ItemStack)outputItem), -outputItem.getCount()));
    }
}

